<?php

use yii\db\Migration;

class m171026_035525_init_addon_neverbounce extends Migration
{
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_neverbounce}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),
            'real_time' => $this->boolean()->notNull()->defaultValue(1),
            'role_address' => $this->boolean()->notNull()->defaultValue(1),
            'disposable' => $this->boolean()->notNull()->defaultValue(1),
            // Authorization
            'private_api_key' => $this->text()->notNull(),
            'public_api_key' => $this->text(),
            // Additional Settings
            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_neverbounce_item}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(), // Form Field ID
            'field_message' => $this->text(), // Field Message
        ], $tableOptions);
    }

    public function down()
    {
        $this->dropTable('{{%addon_neverbounce_item}}');
        $this->dropTable('{{%addon_neverbounce}}');
    }

}
