<?php

namespace app\modules\addons\modules\neverbounce\controllers;

use Yii;
use yii\web\Response;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use app\modules\addons\modules\neverbounce\models\NeverBounce;
use app\modules\addons\modules\neverbounce\services\NeverBounceService;

class CheckController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'email' => ['post'],
                ],
            ],
        ];
    }

	/**
	 * Validate an Email Address
     *
	 * @param $id
	 * @throws NotFoundHttpException
	 * @throws \Exception
	 */
    public function actionEmail($id)
    {
        $email = Yii::$app->request->post('email');
        $success = false;
        if (!empty($email)) {
            $model = $this->findModel($id);
            $neverBounceService = new NeverBounceService($model->private_api_key);
            $success = $neverBounceService->validateEmail($email);
        }

        /** @var \yii\web\Response $response */
        $response = Yii::$app->getResponse();
        $response->format = Response::FORMAT_JSON;
        $response->data = array(
            'success' => $success,
        );
        $response->send();
        exit;
    }

    /**
     * Finds the model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     *
     * @param integer $id Form ID
     * @return NeverBounce the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = NeverBounce::findOne(['form_id' => $id])) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}