<?php

use app\helpers\Html;
use \yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\microsoft_dynamics\models\MicrosoftDynamics */
/* @var $resent int */

$this->title = Yii::t('app', 'Sending Form Submissions to Microsoft Dynamics');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Microsoft Dynamics'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Form') .' #'.
    $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = $this->title;

?>

<div class="microsoft_dynamics-sending box box-big box-light">

    <div class="box-header">
        <h3 class="box-title"><?= $this->title ?>
            <span class="box-subtitle"><?= Html::encode($model->name) ?></span>
        </h3>
    </div>

    <div class="row mt-4 mb-4">
        <div class="col-sm-12">
            <div class="alert alert-warning">
                <?= Yii::t('app', 'Please wait while the data is being imported. Do not update the page or close your browser window.') ?>
            </div>
            <div class="alert alert-success" style="display: none">
                <?= Yii::t('app', 'All data has been successfully imported.') ?>
            </div>
            <div class="alert alert-danger" style="display: none">
                <?= Yii::t('app', 'A problem occurred while importing the data. Please refresh the page to start the process again.') ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="progress">
                <div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;">
                    0%
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <a href="<?= Url::to(['index'])?>" class="btn btn-primary" style="display: none"><?= Yii::t('app', 'Done!') ?></a>
        </div>
    </div>

</div>

<?php

$processUrl = Url::to(['process', 'id' => $model->id, 'resent' => $resent]);

$script = <<< JS
$(document).ready(function(){
    var Batch = {
    
        init : function() {
            this.submit();
        },
    
        submit : function() {
    
            var self = this;
    
            // start the process
            self.process(0, self);
    
        },
    
        process : function(step, self) {
    
            $.ajax({
                type: 'GET',
                url: '{$processUrl}',
                data: {
                    step: step,
                },
                dataType: "json",
                success: function (response) {
                    var progressBar = $('.progress-bar');
                    progressBar.animate({
                        width: response.percentage + '%',
                    }, 50, function() {
                        // Animation complete.
                    });
                    progressBar.html(response.percentage + '%');
                    if ('done' === response.step || response.error) {
                        if (response.error) {
                            $('.alert').hide();
                            $('.alert-danger').show();  
                            $('.progress-bar').addClass('progress-bar-danger');
                        } else {
                            $('.alert').hide();
                            if (response.message.length > 0) {
                                $('.alert-success').html(response.message);
                            }
                            $('.alert-success').show();
                            $('.btn').show();    
                        }
                    } else {
                        self.process(parseInt(response.step ), self);
                    }
                }
            }).fail(function (response) {
                $('.alert').hide();
                $('.alert-danger').show();
                $('.progress-bar').addClass('progress-bar-danger');
            });
        }
    };
    Batch.init();a
});
JS;
$this->registerJs($script, $this::POS_END);
?>