<?php

namespace app\modules\addons\modules\microsoft_dynamics\models;

use Yii;

/**
 * This is the model class for table "{{%addon_microsoft_dynamics_item}}".
 *
 * @property integer $id
 * @property integer $microsoft_dynamics_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class MicrosoftDynamicsField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_microsoft_dynamics_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['microsoft_dynamics_id', 'form_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'microsoft_dynamics_id' => Yii::t('app', 'Microsoft Dynamics ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getMicrosoftDynamics()
    {
        return $this->hasOne(MicrosoftDynamics::class,['id'=>'microsoft_dynamics_id']);
    }
}
