<?php

namespace app\modules\addons\modules\microsoft_dynamics\models;

use app\components\behaviors\DateTrait;
use Yii;
use app\models\Form;
use app\models\User;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use app\components\behaviors\RelationTrait;

/**
 * This is the model class for table "{{%addon_microsoft_dynamics}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $status
 * @property string $name
 * @property integer $event
 * @property string $conditions
 * @property string $instance_uri
 * @property string $application_id
 * @property string $application_secret
 * @property array|string $list_id
 * @property string $email_field
 * @property string $account_name_field
 * @property string $first_name_field
 * @property string $last_name_field
 * @property integer $action
 * @property string $search_by
 * @property integer $search_priority
 * @property integer $update_duplicated
 * @property integer $qualify_lead
 * @property integer $create_account
 * @property integer $create_contact
 * @property integer $create_opportunity
 * @property integer $has_marketing_list
 * @property string $marketing_list
 * @property string $note
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Form $form
 * @property MicrosoftDynamicsField[] $items
 * @property User $author
 * @property User $lastEditor
 */
class MicrosoftDynamics extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    const ACTION_SEARCH_AND_CREATE = 0;
    const ACTION_SEARCH_AND_UPDATE = 1;
    const ACTION_SEARCH_AND_UPDATE_OR_CREATE = 2;

    const SEARCH_PRIORITY_BY_CONTACT = 1;
    const SEARCH_PRIORITY_BY_LEAD = 2;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_microsoft_dynamics}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'name', 'instance_uri', 'application_id', 'application_secret', 'list_id'], 'required'],
            [['form_id', 'status', 'event', 'action', 'search_priority', 'update_duplicated', 'qualify_lead', 'create_account', 'create_contact', 'create_opportunity', 'has_marketing_list', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['name', 'conditions', 'instance_uri', 'application_id', 'application_secret', 'search_by', 'marketing_list', 'notes', 'email_field', 'account_name_field', 'first_name_field', 'last_name_field'], 'string'],
            [['marketing_list'], 'required', 'when' => function ($model) {
                return $model->has_marketing_list == $this::ON;
            }, 'whenClient' => "function (attribute, value) {
                return $(\"input[name='MicrosoftDynamics[has_marketing_list]']:checked\").val() == '".$this::ON."';
            }"],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'name' => Yii::t('app', 'Name'),
            'event' => Yii::t('app', 'Event'),
            'conditions' => Yii::t('app', 'Conditions'),
            'instance_uri' => Yii::t('app', 'Dynamics CMR Address (URL)'),
            'application_id' => Yii::t('app', 'Application Id'),
            'application_secret' => Yii::t('app', 'Application Secret'),
            'list_id' => Yii::t('app', 'List'),
            'email_field' => Yii::t('app', 'Email Field'),
            'account_name_field' => Yii::t('app', 'Account Name Field'),
            'first_name_field' => Yii::t('app', 'First Name Field'),
            'last_name_field' => Yii::t('app', 'Last Name Field'),
            'action' => Yii::t('app', 'Action'),
            'search_by' => Yii::t('app', 'Search By'),
            'search_priority' => Yii::t('app', 'Search Priority'),
            'update_duplicated' => Yii::t('app', 'When Duplicated Record'),
            'qualify_lead' => Yii::t('app', 'Qualify Lead'),
            'create_account' => Yii::t('app', 'Create Account'),
            'create_contact' => Yii::t('app', 'Create Contact'),
            'create_opportunity' => Yii::t('app', 'Create Opportunity'),
            'has_marketing_list' => Yii::t('app', 'Add to Marketing List'),
            'marketing_list' => Yii::t('app', 'Marketing List'),
            'notes' => Yii::t('app', 'Notes'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(MicrosoftDynamicsField::class, ['microsoft_dynamics_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function afterFind()
    {
        $this->list_id = explode(',', $this->list_id);

        parent::afterFind();
    }

    /**
     * @inheritdoc
     */
    public function beforeValidate()
    {
        if (is_array($this->list_id)) {
            $this->list_id = implode(',', $this->list_id);
        }

        return parent::beforeValidate();
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            MicrosoftDynamicsField::deleteAll(["microsoft_dynamics_id" => $this->id]);
            MicrosoftDynamicsLog::deleteAll(["microsoft_dynamics_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }

}
