<?php

use yii\db\Migration;

/**
 * Class m200514_204845_upgrade_to_1_1
 */
class m200514_204845_upgrade_to_1_1 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_microsoft_dynamics_log}}', [
            'id' => $this->primaryKey(),
            'microsoft_dynamics_id' => $this->integer(11),
            'form_id' => $this->integer(11),
            'submission_id' => $this->integer(11),

            'log' => $this->text(), // CRM response
            'status' => $this->boolean()->notNull()->defaultValue(0),

            'created_by' => $this->integer(),
            'updated_by' => $this->integer(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_microsoft_dynamics_log}}');
    }

}
