<?php

namespace app\modules\addons\modules\mailwizz\services;

use Exception;
use Yii;

class MailwizzService
{
    /** @var string Public Api Key */
    protected $publicKey;

    /** @var string Private Api Key */
    protected $privateKey;

    /** @var string Base Url */
    protected $baseUrl = "http://demo.mailwizz.com/api/";

    /**
     * MailwizzService constructor.
     * @param $publicKey
     * @param $privateKey
     * @param $baseUrl
     * @throws Exception
     */
    public function __construct($publicKey, $privateKey, $baseUrl)
    {
        if (empty($publicKey) || empty($privateKey) || empty($baseUrl)) {
            throw new Exception('The public key or private key or api url is empty');
        }

        require_once(Yii::getAlias('@addons/mailwizz/services/vendor/autoload.php'));

        \MailWizzApi_Autoloader::register();

        $config = new \MailWizzApi_Config(array(
            'apiUrl'        => $baseUrl,
            'publicKey'     => $publicKey,
            'privateKey'    => $privateKey,
        ));

        \MailWizzApi_Base::setConfig($config);
    }

    /**
     * Get Subscriber Lists
     *
     * @return array
     * @throws Exception
     */
    public function getSubscriberLists()
    {
        $endpoint = new \MailWizzApi_Endpoint_Lists();
        $response = $endpoint->getLists($pageNumber = 1, $perPage = 1000);
        $lists = [];
        if (isset($response->body['data']['records'])) {
            $records = $response->body['data']['records'];
            if (is_array($records) && !empty($records)) {
                foreach($records as $list) {
                    if (isset($list['general']['list_uid'], $list['general']['name'])) {
                        $lists[$list['general']['list_uid']] = $list['general']['name'];
                    }
                }
            }
        }
        return $lists;
    }

    /**
     * Get Custom Fields
     *
     * @param int $listId
     * @return array
     * @throws Exception
     */
    public function getCustomFields($listId)
    {
        $endpoint = new \MailWizzApi_Endpoint_ListFields();
        $response = $endpoint->getFields($listId);
        $fields = [];
        if (isset($response->body['data']['records'])) {
            $records = $response->body['data']['records'];
            if (is_array($records) && !empty($records)) {
                foreach ($records as $field) {
                    if (isset($field['tag'], $field['label'])) {
                        $fields[$field['tag']] = $field['label'];
                    }
                }
            }
        }
        return $fields;
    }

    /**
     * Add or Update Subscriber
     *
     * @param int $listID
     * @param array $contact
     * @return bool
     * @throws Exception
     */
    public function syncSubscriber($listID, $contact)
    {
        $endpoint   = new \MailWizzApi_Endpoint_ListSubscribers();
        $response = $endpoint->emailSearch($listID, $contact['EMAIL']);
        if (isset($response->body['data']['subscriber_uid'])) {
            $response   = $endpoint->update($listID, $response->body['data']['subscriber_uid'], $contact);
        } else {
            $response   = $endpoint->create($listID, $contact);
        }
        $response = $response->body;

        return $response->itemAt('status') == 'success';
    }
}