<?php

namespace app\modules\addons\modules\mailwizz\models;

use Yii;

/**
 * This is the model class for table "{{%addon_mailwizz_item}}".
 *
 * @property integer $id
 * @property integer $mailwizz_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class MailwizzField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_mailwizz_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'mailwizz_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'mailwizz_id' => Yii::t('app', 'Mailwizz ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getMailwizz()
    {
        return $this->hasOne(Mailwizz::class,['mailwizz_id'=>'id']);
    }
}
