<?php

use yii\db\Migration;

/**
 * Class m210501_161853_mailwizz_1_0
 */
class m210501_161853_mailwizz_1_0 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_mailwizz}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),
            'name' => $this->text()->notNull(),
            'event' => $this->integer()->notNull()->defaultValue(1),
            'conditions' => $this->text(),

            // Authorization
            'public_key' => $this->text()->notNull(),
            'private_key' => $this->text()->notNull(),
            'api_url' => $this->text()->notNull(),
            // List Information
            'contact_list' => $this->text()->notNull(),
            // Subscriber Fields
            'subscriber_email' => $this->text()->notNull(),
            'subscriber_status' => $this->string(191)->notNull()->defaultValue('SUBSCRIBED'),
            // Settings
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->text(),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_mailwizz_field}}', [
            'id' => $this->primaryKey(),
            'mailwizz_id' => $this->integer(11),
            'form_id' => $this->integer(11),
            'form_field' => $this->text(),
            'list_field' => $this->text(),
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_mailwizz_field}}');
        $this->dropTable('{{%addon_mailwizz}}');
    }

}
