<?php

namespace app\modules\addons\modules\mailerlite\models;

use Yii;

/**
 * This is the model class for table "{{%addon_mailerlite_item}}".
 *
 * @property integer $id
 * @property integer $mailerlite_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class MailerLiteField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_mailerlite_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['mailerlite_id', 'form_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'mailerlite_id' => Yii::t('app', 'MailerLite ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getMailerLite()
    {
        return $this->hasOne(MailerLite::class,['mailerlite_id'=>'id']);
    }
}
