<?php

use yii\db\Migration;

/**
 * Class m200627_222456_update_to_1_2
 */
class m200627_222456_update_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_mailerlite}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_mailerlite}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_mailerlite}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_mailerlite_field}}', 'mailerlite_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_mailerlite_field}}', 'mailerlite_id');

        $this->dropColumn('{{%addon_mailerlite}}', 'event');
        $this->dropColumn('{{%addon_mailerlite}}', 'conditions');
        $this->dropColumn('{{%addon_mailerlite}}', 'name');
    }

}
