<?php

use app\components\widgets\ConditionsBuilder;
use kartik\depdrop\DepDrop;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\mailchimp\models\Mailchimp */
/* @var $fieldModel app\modules\addons\modules\mailchimp\models\MailchimpField */
/* @var $forms array [id => name] of Form models */
/* @var $lists array [id => name] of Mailchimp Subscriber Lists */
/* @var $connected boolean The connection to Mailchimp have beed stablished */

$this->title = Yii::t('app', 'Create Sign Up Form');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'MailChimp'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$formFieldUrl = Url::to(['/addons/mailchimp/admin/fields']);
$listFieldUrl = Url::to(['/addons/mailchimp/admin/mailchimp-fields']);

?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(); ?>
                        <div class="row">
                            <div class="col-sm-12">
                                <?= $form->field($model, 'api_key')->textInput([
                                    'maxlength' => true,
                                ]) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <span class="help-block">
                                    <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                                    <?= Yii::t(
                                        'app',
                                        'For connecting to your MailChimp account you need your API Key.'
                                    ) ?>
                                    <?= Html::a(Yii::t('app', 'Go to MailChimp'), 'https://www.mailchimp.com', ['target' => '_blank']) ?>.
                                </span>
                            </div>
                        </div>
                        <?php if ($connected && !empty($model->api_key)): ?>
                            <div class="row" style="margin-top: 20px;">
                                <div class="col-sm-12">
                                    <?= $form->field($model, 'name')->textInput([
                                        'placeholder' => Yii::t('app', "Enter a configuration name..."),
                                        'maxlength' => true,
                                    ]) ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'form_id')->widget(Select2::class, [
                                        'data' => $forms,
                                        'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                                        'pluginOptions' => [
                                            'allowClear' => true
                                        ],
                                    ])->label(Yii::t('app', 'Form')); ?>
                                </div>
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'list_id')->widget(Select2::class, [
                                        'data' => $lists,
                                        'options' => ['placeholder' => Yii::t('app', 'Select a list...')],
                                        'pluginOptions' => [
                                            'allowClear' => true
                                        ],
                                        'pluginEvents' => [
                                            "select2:select" => "function(event) {
                                                $('#mailchimp-list_name').val($(event.currentTarget).find('option:selected').text());
                                            }",
                                        ],
                                    ])->hint( Yii::t(
                                        'app',
                                        'Select the list in which you want to add subscribers.'
                                    ))->label(Yii::t('app', 'List')); ?>
                                    <?= $form->field($model, 'list_name')->hiddenInput()->label(false) ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3">
                                    <?php if ($model->isNewRecord) { $model->status = 1;} ?>
                                    <?= $form->field($model, 'status')->widget(SwitchInput::class)->hint(Yii::t(
                                        'app',
                                        'Disables the integration at any time.'
                                    )) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?php if ($model->isNewRecord) { $model->subscriber_ip_address = 1;} ?>
                                    <?= $form->field($model, 'subscriber_ip_address')->widget(SwitchInput::class)->hint( Yii::t(
                                        'app',
                                        'Useful for GeoLocation.'
                                    )) ?>
                                </div>
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'event')->widget(Select2::class, [
                                        'data' => \app\helpers\EventHelper::supportedFormEvents(),
                                    ]); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <?= ConditionsBuilder::widget([
                                        'label' => Yii::t('app', 'Conditions'),
                                    ]) ?>
                                    <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'subscriber_email')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['mailchimp-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $formFieldUrl,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($model, 'subscriber_status')->dropDownList([
                                        'subscribed'=> YII::t('app', 'Subscribed'),
                                        'unsubscribed' => YII::t('app', 'Unsubscribed'),
                                        'cleaned' => YII::t('app', 'Cleaned'),
                                        'pending' => YII::t('app', 'Pending'),
                                        'transactional' => YII::t('app', 'Transactional'),
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($model, 'subscriber_interests')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['mailchimp-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $formFieldUrl,
                                        ]
                                    ]) ?>
                                </div>
                            </div>
                            <fieldset class="item">
                                <div class="row">
                                    <div class="col-sm-5">
                                        <?= $form->field($fieldModel, '[0]form_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['mailchimp-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $formFieldUrl,
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-1" style="padding-top: 28px">
                                        <div class="text-primary" style="font-size: 22px; padding: 5px 18px 4px 22px; line-height: 22px;">
                                            <i class="fas fa-arrow-alt-right"></i>
                                        </div>
                                    </div>
                                    <div class="col-sm-5">
                                        <?= $form->field($fieldModel, '[0]list_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['mailchimp-list_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $listFieldUrl,
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-1">
                                        <div class="form-group" style="padding-top: 28px;">
                                            <button type="button" class="btn btn-icon btn-default btn-add">
                                                <i class="fas fa-plus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                            <fieldset id="itemTemplate" class="d-none">
                                <div class="row">
                                    <div class="col-sm-5">
                                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['mailchimp-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $formFieldUrl,
                                            ],
                                            'pluginEvents' => [
                                                "depdrop:afterChange" => "function(event, id, value) { 
                                                    $(event.currentTarget).attr('disabled', true)
                                                }",
                                            ],
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-1" style="padding-top: 28px">
                                        <div class="text-primary" style="font-size: 22px; padding: 5px 18px 4px 22px; line-height: 22px;">
                                            <i class="fas fa-arrow-alt-right"></i>
                                        </div>
                                    </div>
                                    <div class="col-sm-5">
                                        <?= $form->field($fieldModel, 'list_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['mailchimp-list_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $listFieldUrl,
                                            ],
                                            'pluginEvents' => [
                                                "depdrop:afterChange" => "function(event, id, value) { 
                                                    $(event.currentTarget).attr('disabled', true)
                                                }",
                                            ],
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-1">
                                        <div class="form-group" style="padding-top: 28px;">
                                            <button type="button" class="btn btn-icon btn-default btn-remove">
                                                <i class="fas fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>

                        <?php endif; ?>

                        <div class="form-group" style="margin-top: 15px">
                            <?= Html::submitButton( !$connected ?
                                ' <i class="fas fa-external-link-square me-2"></i> ' . Yii::t('app', 'Connect to MailChimp'):
                                ' <i class="fas fa-check me-2"></i> ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#mailchimp-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['mailchimp-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'mailchimp-conditions');

/**
 * Field Mapping
 */

$script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="MailchimpField[form_field]"]')
                    .attr('name', 'MailchimpField[' + item + '][form_field]')
                    .attr('id', 'mailchimpfield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['mailchimp-form_id'],
                        url: '$formFieldUrl'
                    })
                    .end()
                .find('[name="MailchimpField[list_field]"]')
                    .attr('name', 'MailchimpField[' + item + '][list_field]')
                    .attr('id', 'mailchimpfield-' + item + '-list_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['mailchimp-list_id'],
                        url: '$listFieldUrl'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

$this->registerJs($script, $this::POS_END, 'mailchimp');

?>