<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\mailchimp\models;

use app\components\behaviors\DateTrait;
use Yii;
use app\models\Form;
use app\models\User;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use app\components\behaviors\RelationTrait;

/**
 * This is the model class for table "{{%addon_mailchimp}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $status
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property string $api_key
 * @property string $consumer_key
 * @property string $consumer_secret
 * @property string $access_token
 * @property string $access_secret
 * @property string $list_id
 * @property string $list_name
 * @property string $subscriber_email
 * @property string $subscriber_status
 * @property string $subscriber_interests
 * @property integer $subscriber_ip_address
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 *
 * @property Form $form
 * @property MailchimpField[] $items
 * @property User $author
 * @property User $lastEditor
 */
class Mailchimp extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_mailchimp}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'form_id', 'api_key', 'list_id', 'list_name', 'subscriber_email', 'subscriber_status'], 'required'],
            [['form_id', 'status', 'event', 'subscriber_ip_address', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['name', 'conditions'], 'string'],
            [['api_key', 'list_id', 'list_name', 'subscriber_email', 'subscriber_status', 'subscriber_interests'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'api_key' => Yii::t('app', 'Api Key'),
            'list_id' => Yii::t('app', 'List ID'),
            'list_name' => Yii::t('app', 'List Name'),
            'subscriber_email' => Yii::t('app', 'Subscriber Email Address'),
            'subscriber_status' => Yii::t('app', 'Subscriber Status'),
            'subscriber_interests' => Yii::t('app', 'Subscriber Interests'),
            'subscriber_ip_address' => Yii::t('app', 'Subscriber\'s IP Address'),
            'created_by' => Yii::t('app', 'Created by'),
            'updated_by' => Yii::t('app', 'Updated by'),
            'created_at' => Yii::t('app', 'Created at'),
            'updated_at' => Yii::t('app', 'Updated at'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(MailchimpField::class, ['mailchimp_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            MailchimpField::deleteAll(["mailchimp_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }
}