<?php

use yii\db\Migration;

/**
 * Class m200627_211000_update_to_1_3
 */
class m200627_211000_update_to_1_3 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_mailchimp}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_mailchimp}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_mailchimp}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_mailchimp_field}}', 'mailchimp_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_mailchimp_field}}', 'mailchimp_id');

        $this->dropColumn('{{%addon_mailchimp}}', 'event');
        $this->dropColumn('{{%addon_mailchimp}}', 'conditions');
        $this->dropColumn('{{%addon_mailchimp}}', 'name');
    }

}
