<?php

use yii\db\Migration;

class m170404_135121_init_addon_mailchimp extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_mailchimp}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),
            // Authorization
            'api_key' => $this->text()->notNull(),
            // Required Information
            'list_id' => $this->text()->notNull(),
            'list_name' => $this->text()->notNull(),
            // Subscriber Fields
            'subscriber_email' => $this->text()->notNull(),
            'subscriber_status' => $this->text()->notNull(),
            'subscriber_interests' => $this->text(),
            // Settings
            'subscriber_ip_address' => $this->boolean()->defaultValue(1),
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->text(),
            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_mailchimp_field}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'form_field' => $this->text(), // Easy Forms Form Field
            'list_field' => $this->text(), // Mailchimp Subscriber List Field
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_mailchimp_field}}');
        $this->dropTable('{{%addon_mailchimp}}');
    }
}
