<?php

use app\modules\addons\modules\limit_choices\models\LimitChoices;
use app\modules\addons\modules\limit_choices\models\LimitChoicesItem;
use yii\helpers\Html;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\limit_choices\models\LimitChoices */
/* @var $itemModel app\modules\addons\modules\limit_choices\models\LimitChoicesItem */
/* @var $forms array [id => name] of Form models */

$fieldsUrl = Url::to(['/addons/limit_choices/admin/fields']);
$choicesUrl = Url::to(['/addons/limit_choices/admin/choices']);
$scopeOptions = [
    LimitChoicesItem::SCOPE_CHOICE => Yii::t('app', 'Individual Choice'),
    LimitChoicesItem::SCOPE_FIELD => Yii::t('app', 'All Choices')
];

?>

<style>
    .row {
        margin-bottom: 20px;
    }
</style>
<div class="limit_choices-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'unavailable')->widget(Select2::class, [
                'data' => [
                    LimitChoices::UNAVAILABLE_DISABLE => Yii::t('app', 'Disable Choice'),
                    LimitChoices::UNAVAILABLE_HIDE => Yii::t('app', 'Hide Choice'),
                    LimitChoices::UNAVAILABLE_DISABLE_FIELD => Yii::t('app', 'Disable Field'),
                    LimitChoices::UNAVAILABLE_DISABLE_FORM => Yii::t('app', 'Disable Form'),
                ],
                'options' => ['placeholder' => Yii::t('app', 'Select an action...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'remaining_quantity')->widget(SwitchInput::class) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'remaining_quantity_text')->textInput([
                'maxlength' => true,
                'placeholder' => Yii::t('app', '(Available: {choices})'),
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'remaining_quantity_error')->textInput([
                'maxlength' => true,
                'placeholder' => Yii::t('app', '(Not Available)'),
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
        </div>
    </div>

    <?php if ($model->isNewRecord || count($model->items) === 0): ?>

        <fieldset class="item">
            <div class="row">
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]scope')->dropDownList($scopeOptions); ?>
                </div>
                <div class="col-sm-4">
                    <?= $form->field($itemModel, '[0]field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['limitchoices-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, '[0]choice_value')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['limitchoices-form_id', 'limitchoicesitem-0-field_id'],
                            'placeholder' => Yii::t('app', 'Select a choice...'),
                            'url' => $choicesUrl,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-add">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]choice_limit')->textInput([
                        'type' => 'number',
                        'min' => 0,
                        'step' => 1,
                        'maxlength' => true,
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]choice_used')->textInput([
                        'type' => 'number',
                        'min' => 0,
                        'step' => 1,
                        'maxlength' => true,
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]choice_remaining')->textInput([
                        'type' => 'number',
                        'min' => 0,
                        'step' => 1,
                        'maxlength' => true,
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, '[0]choice_message')->textInput([
                        'maxlength' => true,
                    ]) ?>
                </div>
            </div>
        </fieldset>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'scope')->dropDownList($scopeOptions,
                        [
                            'disabled' => true,
                        ]
                    ); ?>
                </div>
                <div class="col-sm-4">
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['limitchoices-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'choice_value')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['limitchoices-form_id'],
                            'placeholder' => Yii::t('app', 'Select a choice...'),
                            'url' => $choicesUrl,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'quantity_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['limitchoices-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-remove">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'choice_limit')->textInput([
                        'type' => 'number',
                        'min' => 0,
                        'step' => 1,
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'choice_used')->textInput([
                        'type' => 'number',
                        'min' => 0,
                        'step' => 1,
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'choice_remaining')->textInput([
                        'type' => 'number',
                        'min' => 0,
                        'step' => 1,
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'choice_message')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
            </div>
        </fieldset>

    <?php else: ?>

        <?php foreach($model->items as $i => $item): ?>

            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-2">
                        <?= $form->field($item, '['.$i.']scope')->dropDownList($scopeOptions); ?>
                    </div>
                    <div class="col-sm-4">
                        <?= Html::hiddenInput('item-'.$i.'-field_id',
                            $item->field_id, ['id'=>'item-'.$i.'-field_id']) ?>
                        <?= $form->field($item, '['.$i.']field_id')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['limitchoices-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $fieldsUrl,
                                'params'=>['item-'.$i.'-field_id'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-'.$i.'-choice_value',
                            $item->choice_value, ['id'=>'item-'.$i.'-choice_value']) ?>
                        <?php /* $form->field($item, '['.$i.']choice_value')->widget(DepDrop::class, [
                                'value' => 'test',
                            'pluginOptions' => [
                                'depends' => ['limitchoices-form_id', 'limitchoicesitem-'.$i.'-field_id'],
                                'placeholder' => Yii::t('app', 'Select a choice...'),
                                'url' => $choicesUrl,
                                'params' => ['item-'.$i.'-choice_value']
                            ]
                        ]) */ ?>

                        <?= $form->field($item, '['.$i.']choice_value')->dropDownList([
                            '' => Yii::t('app', 'Select a choice...'),
                            'Quad' => 'Quad',
                            'Triple' => 'Triple',
                            'Double' => 'Double'
                        ], [
                            'class' => 'form-control',
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('item-'.$i.'-quantity_id',
                            $item->quantity_id, ['id'=>'item-'.$i.'-quantity_id']) ?>
                        <?= $form->field($item, '['.$i.']quantity_id')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['limitchoices-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $fieldsUrl,
                                'params'=>['item-'.$i.'-quantity_id'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($item, '['.$i.']choice_limit')->textInput([
                            'type' => 'number',
                            'min' => 0,
                            'step' => 1,
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($item, '['.$i.']choice_used')->textInput([
                            'type' => 'number',
                            'min' => 0,
                            'step' => 1,
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($item, '['.$i.']choice_remaining')->textInput([
                            'type' => 'number',
                            'min' => 0,
                            'step' => 1,
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($item, '['.$i.']choice_message')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                </div>
            </fieldset>

        <?php endforeach; ?>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'scope')->dropDownList($scopeOptions,
                        [
                            'disabled' => true,
                        ]
                    ); ?>
                </div>
                <div class="col-sm-4">
                    <?= Html::hiddenInput('item-field_id', '', ['id'=>'item-field_id']) ?>
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['limitchoices-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'params'=>['item-field_id'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= Html::hiddenInput('item-choice_value', '', ['id'=>'item-choice_value']) ?>
                    <?= $form->field($itemModel, 'choice_value')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['limitchoices-form_id'],
                            'placeholder' => Yii::t('app', 'Select a choice...'),
                            'url' => $choicesUrl,
                            'params'=>['item-choice_value'],
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= Html::hiddenInput('item-quantity_id', '', ['id'=>'item-quantity_id']) ?>
                    <?= $form->field($itemModel, 'quantity_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['limitchoices-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'params'=>['item-quantity_id'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'choice_limit')->textInput([
                        'type' => 'number',
                        'min' => 0,
                        'step' => 1,
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'choice_used')->textInput([
                        'type' => 'number',
                        'min' => 0,
                        'step' => 1,
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'choice_remaining')->textInput([
                        'type' => 'number',
                        'min' => 0,
                        'step' => 1,
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'choice_message')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
            </div>
        </fieldset>

    <?php endif; ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ?
            Yii::t('app', 'Save') :
            Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Field Mapping
 */

if ($model->isNewRecord || count($model->items) === 0) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="LimitChoicesItem[scope]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][scope]')
                    .attr('id', 'limitchoicesitem-' + item + '-scope')
                    .removeAttr('disabled')
                    .end()
                .find('[name="LimitChoicesItem[field_id]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][field_id]')
                    .attr('id', 'limitchoicesitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['limitchoices-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="LimitChoicesItem[choice_value]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_value]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_value')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['limitchoices-form_id', 'limitchoicesitem-' + item + '-field_id'],
                        url: '{$choicesUrl}'
                    })
                    .end()
                .find('[name="LimitChoicesItem[quantity_id]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][quantity_id]')
                    .attr('id', 'limitchoicesitem-' + item + '-quantity_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['limitchoices-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="LimitChoicesItem[choice_limit]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_limit]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_limit')
                    .removeAttr('disabled')
                    .end()
                .find('[name="LimitChoicesItem[choice_used]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_used]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_used')
                    .removeAttr('disabled')
                    .end()
                .find('[name="LimitChoicesItem[choice_remaining]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_remaining]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_remaining')
                    .removeAttr('disabled')
                    .end()
                .find('[name="LimitChoicesItem[choice_message]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_message]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_message')
                    .removeAttr('disabled')
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#limitchoices-form_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="LimitChoicesItem[scope]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][scope]')
                    .attr('id', 'limitchoicesitem-' + item + '-scope')
                    .removeAttr('disabled')
                    .end()
                .find('[name="LimitChoicesItem[field_id]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][field_id]')
                    .attr('id', 'limitchoicesitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['limitchoices-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="LimitChoicesItem[choice_value]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_value]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_value')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['limitchoices-form_id', 'limitchoicesitem-' + item + '-field_id'],
                        url: '{$choicesUrl}'
                    })
                    .end()
                .find('[name="LimitChoicesItem[quantity_id]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][quantity_id]')
                    .attr('id', 'limitchoicesitem-' + item + '-quantity_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['limitchoices-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="LimitChoicesItem[choice_limit]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_limit]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_limit')
                    .removeAttr('disabled')
                    .end()
                .find('[name="LimitChoicesItem[choice_used]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_used]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_used')
                    .removeAttr('disabled')
                    .end()
                .find('[name="LimitChoicesItem[choice_remaining]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_remaining]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_remaining')
                    .removeAttr('disabled')
                    .end()
                .find('[name="LimitChoicesItem[choice_message]"]')
                    .attr('name', 'LimitChoicesItem[' + item + '][choice_message]')
                    .attr('id', 'limitchoicesitem-' + item + '-choice_message')
                    .removeAttr('disabled')
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
}

$this->registerJs($script, $this::POS_END);

?>