<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\limit_choices\models;

use Yii;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_limit_choices_item_tracking}}".
 *
 * @property int $id
 * @property int $limit_choices_id
 * @property int $form_id
 * @property int $submission_id
 * @property string $field_id
 * @property string $choice_label
 * @property int $choice_value
 * @property int $created_by
 * @property int $updated_by
 * @property int $created_at
 * @property int $updated_at
 */
class LimitChoicesItemTracking extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_limit_choices_item_tracking}}';
    }

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['limit_choices_id', 'form_id', 'submission_id'], 'integer'],
            [['field_id', 'choice_label', 'choice_value'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'limit_choices_id' => Yii::t('app', 'Limit Choices ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'submission_id' => Yii::t('app', 'Submission ID'),
            'field_id' => Yii::t('app', 'Field ID'),
            'choice_label' => Yii::t('app', 'Choice Label'),
            'choice_value' => Yii::t('app', 'Choice Value'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLimitChoices()
    {
        return $this->hasOne(LimitChoices::class, ['id' => 'limit_choices_id']);
    }
}
