<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\limit_choices\models;

use app\models\Form;
use Yii;

/**
 * This is the model class for table "{{%addon_limit_choices_item}}".
 *
 * @property int $id
 * @property int $limit_choices_id
 * @property int $form_id
 * @property string $field_id
 * @property string $quantity_id
 * @property string $scope
 * @property string $choice_value
 * @property int $choice_limit
 * @property int $choice_used
 * @property int $choice_remaining
 * @property string $choice_message
 * @property int $show_remaining
 * @property string $reset_every
 * @property int $reset_at
 *
 * @property LimitChoices $limitChoices
 */
class LimitChoicesItem extends \yii\db\ActiveRecord
{
    const SCOPE_CHOICE = "choice";
    const SCOPE_FIELD = "field";

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_limit_choices_item}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['limit_choices_id', 'form_id', 'choice_limit', 'choice_used', 'choice_remaining', 'show_remaining', 'reset_at'], 'integer'],
            [['field_id', 'quantity_id', 'scope', 'choice_value'], 'string', 'max' => 255],
            [['choice_message'], 'string', 'max' => 2555],
            [['reset_every'], 'string', 'max' => 5],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'limit_choices_id' => Yii::t('app', 'Limit Choices ID'),
            'form_id' => Yii::t('app', 'Form'),
            'field_id' => Yii::t('app', 'Field'),
            'quantity_id' => Yii::t('app', 'Quantity Field'),
            'scope' => Yii::t('app', 'Scope'),
            'choice_value' => Yii::t('app', 'Choice'),
            'choice_limit' => Yii::t('app', 'Limit'),
            'choice_used' => Yii::t('app', 'Used'),
            'choice_remaining' => Yii::t('app', 'Remaining'),
            'choice_message' => Yii::t('app', 'Error Message'),
            'show_remaining' => Yii::t('app', 'Show Remaining'),
            'reset_every' => Yii::t('app', 'Reset Every'),
            'reset_at' => Yii::t('app', 'Reset At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLimitChoices()
    {
        return $this->hasOne(LimitChoices::class, ['id' => 'limit_choices_id']);
    }

    /*
     * @inheritdoc
     */
    public function beforeSave($insert)
    {
        if (!parent::beforeSave($insert)) {
            return false;
        }

        // Default values
        $this->choice_limit = trim($this->choice_limit) === '' ? 0 : $this->choice_limit;
        $this->choice_used = trim($this->choice_used) === '' ? 0 : $this->choice_used;
        $this->choice_remaining = trim($this->choice_remaining) === '' ? 0 : $this->choice_remaining;

        // Limit can't be less than remaining
        if ($this->choice_limit < $this->choice_remaining) {
            $this->choice_limit = $this->choice_remaining;
        }

        return true;
    }
}