<?php

use yii\db\Migration;

/**
 * Class m211113_025936_limit_choices_1_1
 */
class m211113_025936_limit_choices_1_1 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%addon_limit_choices}}', 'unavailable', $this->string(191)->defaultValue('disabled')->after('status'));
        $this->addColumn('{{%addon_limit_choices}}', 'remaining_quantity', $this->boolean()->defaultValue(0)->after('unavailable'));
        $this->addColumn('{{%addon_limit_choices}}', 'remaining_quantity_text', $this->text()->after('remaining_quantity'));
        $this->addColumn('{{%addon_limit_choices}}', 'remaining_quantity_error', $this->text()->after('remaining_quantity_text'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_limit_choices}}', 'unavailable');
        $this->dropColumn('{{%addon_limit_choices}}', 'remaining_quantity');
        $this->dropColumn('{{%addon_limit_choices}}', 'remaining_quantity_text');
        $this->dropColumn('{{%addon_limit_choices}}', 'remaining_quantity_error');
    }

}
