<?php

use yii\db\Migration;

/**
 * Class m210506_171335_limit_choices_1_0
 */
class m210506_171335_limit_choices_1_0 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_limit_choices}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),
            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_limit_choices_item}}', [
            'id' => $this->primaryKey(),
            'limit_choices_id' => $this->integer(11),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(),
            'choice_value' => $this->text(),
            'choice_limit' => $this->integer(),
            'choice_used' => $this->integer(),
            'choice_remaining' => $this->integer(),
            'choice_message' => $this->text(),
            'show_remaining' => $this->boolean()->defaultValue(0),
            'reset_every' => $this->string(5), // NEVER, DAY, WEEK, MONTH or YEAR
            'reset_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_limit_choices_item_tracking}}', [
            'id' => $this->primaryKey(),
            'limit_choices_id' => $this->integer(11),
            'form_id' => $this->integer(11),
            'submission_id' => $this->integer(11),
            'field_id' => $this->text(),
            'choice_label' => $this->text(),
            'choice_value' => $this->text(),
            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_limit_choices_item_tracking}}');
        $this->dropTable('{{%addon_limit_choices_item}}');
        $this->dropTable('{{%addon_limit_choices}}');
    }
}
