<?php

namespace app\modules\addons\modules\insightly\services;

use Exception;
use yii\helpers\Json;

class InsightlyService
{

    /** @var string Api Key */
    protected $apiKey;

    /** @var string Base Url */
    protected $baseUrl = "https://api.insightly.com/v3.1";

    /** @var string Response Format */
    protected $returnFormat = "json";

    /** @var bool Check Header */
    protected $checkHeader = true;

    /** @var bool Throw Exceptions */
    protected $throwExceptions = true;

    /** @var bool Header */
    protected $header = false;

    /** @var bool Error */
    protected $error = false;

    /**
     * InsightlyService constructor.
     * @param $apiKey
     * @throws Exception
     */
    public function __construct($apiKey)
    {
        if (empty($apiKey)) {
            throw new Exception('The api key is empty');
        }
        $this->apiKey = $apiKey;
    }

    /**
     * @return bool
     * @throws Exception
     */
    public function checkConnection()
    {
        $options = [
            CURLOPT_URL => $this->baseUrl . "/Instance",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 0,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => false,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json",
                "Authorization: Basic " . base64_encode($this->apiKey)
            ),
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLINFO_HEADER_OUT => true,
        ];

        $instance  =  (array) $this->request($options);

        return is_array($instance) && isset($instance['INSTANCE_NAME']);
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getLeadStatuses()
    {
        $options = [
            CURLOPT_URL => $this->baseUrl . "/LeadStatuses",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 0,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => false,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json",
                "Authorization: Basic " . base64_encode($this->apiKey)
            ),
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLINFO_HEADER_OUT => true,
        ];

        $collection  =  (array) $this->request($options);

        $items = [];
        if (is_array($collection) && !empty($collection)) {
            foreach($collection as $item) {
                $item = (array) $item;
                if (isset($item['LEAD_STATUS_ID'], $item['LEAD_STATUS'])) {
                    $items[$item['LEAD_STATUS_ID']] = $item['LEAD_STATUS'];
                }
            }
        }

        return $items;
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getLeadSources()
    {
        $options = [
            CURLOPT_URL => $this->baseUrl . "/LeadSources",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 0,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => false,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json",
                "Authorization: Basic " . base64_encode($this->apiKey)
            ),
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLINFO_HEADER_OUT => true,
        ];

        $collection  =  (array) $this->request($options);

        $items = [];
        if (is_array($collection) && !empty($collection)) {
            foreach($collection as $item) {
                $item = (array) $item;
                if (isset($item['LEAD_SOURCE_ID'], $item['LEAD_SOURCE'])) {
                    $items[$item['LEAD_SOURCE_ID']] = $item['LEAD_SOURCE'];
                }
            }
        }

        return $items;
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getCustomFields($objectName)
    {
        $options = [
            CURLOPT_URL => $this->baseUrl . "/CustomFields/{$objectName}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 0,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => false,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json",
                "Authorization: Basic " . base64_encode($this->apiKey)
            ),
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLINFO_HEADER_OUT => true,
        ];

        $collection  =  (array) $this->request($options);

        $items = [];
        if (is_array($collection) && !empty($collection)) {
            foreach($collection as $item) {
                $item = (array) $item;
                if (isset($item['FIELD_NAME'], $item['FIELD_LABEL'])) {
                    // $items[$item['FIELD_NAME']] = $item['FIELD_LABEL'];
                    $items[] = [
                        'id' => $item['FIELD_NAME'],
                        'name' => $item['FIELD_LABEL']
                    ];
                }
            }
        }

        return $items;
    }

    /**
     * Save data
     *
     * @param array $data
     * @param string $endPoint
     * @return array
     * @throws Exception
     */
    public function save($data, $endPoint = 'Leads')
    {
        $data = (is_array($data)) ? Json::encode($data) : $data;

        $options = [
            CURLOPT_URL => $this->baseUrl . "/" . $endPoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 0,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => false,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json",
                "Authorization: Basic " . base64_encode($this->apiKey)
            ),
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLINFO_HEADER_OUT => true,
        ];

        return (array) $this->request($options);
    }

    /**
     * Return formatted response according to settings
     *
     * @param $in
     * @param bool $header
     * @return mixed|null
     * @throws Exception
     */
    protected function response($in, $header = false)
    {
        $this->header = $header;

        if ($this->checkHeader && isset($header["http_code"])) {
            if ($header["http_code"] < 200 || $header["http_code"] >= 300) {
                //error!?
                $this->error = $in;
                $message = var_export($in, true);
                if ($tmp = json_decode($in)) {
                    if (isset($tmp->error->message)) {
                        $message = $tmp->error->message;
                    }
                }
                if ($this->throwExceptions) {
                    throw new \Exception('' . $header["http_code"] . ';' . $message);
                }
                $in = null;

            }

        }

        switch ($this->returnFormat) {
            case 'json':
                return json_decode($in);
                break;

            default:
                return $in;
                break;
        }
        return $in;
    }

    /**
     * @param $options
     * @return mixed|null
     * @throws Exception
     */
    protected function request($options)
    {
        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        $info =  curl_getinfo($curl);
        curl_close($curl);

        return $this->response($response, $info);
    }

}