<?php

namespace app\modules\addons\modules\insightly\models;

use Yii;

/**
 * This is the model class for table "{{%addon_insightly_item}}".
 *
 * @property integer $id
 * @property integer $insightly_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class InsightlyField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_insightly_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['insightly_id', 'form_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'insightly_id' => Yii::t('app', 'Insightly ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInsightly()
    {
        return $this->hasOne(Insightly::class,['insightly_id'=>'id']);
    }
}
