<?php

use yii\db\Migration;

/**
 * Class m200627_203158_update_to_1_2
 */
class m200627_203158_update_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_insightly}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_insightly}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_insightly}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_insightly_field}}', 'insightly_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_insightly_field}}', 'insightly_id');

        $this->dropColumn('{{%addon_insightly}}', 'event');
        $this->dropColumn('{{%addon_insightly}}', 'conditions');
        $this->dropColumn('{{%addon_insightly}}', 'name');
    }
}
