<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Migration;

/**
 * Class m190703_220853_init_addon_insightly
 */
class m190703_220853_init_addon_insightly extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_insightly}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),

            // Authorization
            'api_key' => $this->text()->notNull(),
            // List Information
            'list_id' => $this->text()->notNull(),
            // Required Lead Fields
            'lead_status' => $this->text()->notNull(),
            'lead_source' => $this->text()->notNull(),

            // Settings
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->text(),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_insightly_field}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'form_field' => $this->text(),
            'list_field' => $this->text(),
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_insightly_field}}');
        $this->dropTable('{{%addon_insightly}}');
    }
}
