<?php

namespace app\modules\addons\modules\insightly\helpers;

use Yii;

class Crm
{

    public static function fieldsForList($list)
    {
        if (!in_array($list, static::lists())) {
            throw new \InvalidArgumentException('Invalid list name');
        }

        $fields = static::fields();
        $listFields = [];
        $requiredFields = [];

        if (isset($fields[$list])) {
            foreach ($fields[$list] as $field) {
                $name = $field;
                if (in_array($name, static::requiredFieldsForList($list))) {
                    $name = $name . ' - ' . Yii::t('app', 'Required');
                    $requiredFields[] = [
                        'id' => $field,
                        'name' => $name
                    ];
                } else {
                    $listFields[] = [
                        'id' => $field,
                        'name' => $name
                    ];
                }
            }
        }

        return array_merge($requiredFields, $listFields);
    }

    public static function fields()
    {
        $fields = array();
        $fields['Contacts'] = ["SALUTATION","FIRST_NAME","LAST_NAME","IMAGE_URL","BACKGROUND","OWNER_USER_ID","DATE_CREATED_UTC","DATE_UPDATED_UTC","SOCIAL_LINKEDIN","SOCIAL_FACEBOOK","SOCIAL_TWITTER","DATE_OF_BIRTH","PHONE","PHONE_HOME","PHONE_MOBILE","PHONE_OTHER","PHONE_ASSISTANT","PHONE_FAX","EMAIL_ADDRESS","ASSISTANT_NAME","ADDRESS_MAIL_STREET","ADDRESS_MAIL_CITY","ADDRESS_MAIL_STATE","ADDRESS_MAIL_POSTCODE","ADDRESS_MAIL_COUNTRY","ADDRESS_OTHER_STREET","ADDRESS_OTHER_CITY","ADDRESS_OTHER_STATE","ADDRESS_OTHER_POSTCODE","ADDRESS_OTHER_COUNTRY","LAST_ACTIVITY_DATE_UTC","NEXT_ACTIVITY_DATE_UTC","ORGANISATION_ID","TITLE","TAGS"];
        $fields['Organisations'] = ["ORGANISATION_NAME","BACKGROUND","IMAGE_URL","OWNER_USER_ID","DATE_CREATED_UTC","DATE_UPDATED_UTC","LAST_ACTIVITY_DATE_UTC","NEXT_ACTIVITY_DATE_UTC","PHONE","PHONE_FAX","WEBSITE","ADDRESS_BILLING_STREET","ADDRESS_BILLING_CITY","ADDRESS_BILLING_STATE","ADDRESS_BILLING_COUNTRY","ADDRESS_BILLING_POSTCODE","ADDRESS_SHIP_STREET","ADDRESS_SHIP_CITY","ADDRESS_SHIP_STATE","ADDRESS_SHIP_POSTCODE","ADDRESS_SHIP_COUNTRY","SOCIAL_LINKEDIN","SOCIAL_FACEBOOK","SOCIAL_TWITTER","EMAIL_DOMAIN","TAGS"];
        $fields['Leads'] = ["SALUTATION","FIRST_NAME","LAST_NAME","LEAD_SOURCE_ID","LEAD_STATUS_ID","TITLE","CONVERTED","CONVERTED_CONTACT_ID","CONVERTED_DATE_UTC","CONVERTED_OPPORTUNITY_ID","CONVERTED_ORGANISATION_ID","DATE_CREATED_UTC","DATE_UPDATED_UTC","EMAIL","EMPLOYEE_COUNT","FAX","INDUSTRY","LEAD_DESCRIPTION","LEAD_RATING","MOBILE","OWNER_USER_ID","PHONE","RESPONSIBLE_USER_ID","WEBSITE","ADDRESS_STREET","ADDRESS_CITY","ADDRESS_STATE","ADDRESS_POSTCODE","ADDRESS_COUNTRY","LAST_ACTIVITY_DATE_UTC","NEXT_ACTIVITY_DATE_UTC","ORGANISATION_NAME","TAGS"];
        $fields['Opportunities'] = ["OPPORTUNITY_NAME","OPPORTUNITY_DETAILS","OPPORTUNITY_STATE","RESPONSIBLE_USER_ID","CATEGORY_ID","IMAGE_URL","BID_CURRENCY","BID_AMOUNT","BID_TYPE","BID_DURATION","ACTUAL_CLOSE_DATE","DATE_CREATED_UTC","DATE_UPDATED_UTC","OPPORTUNITY_VALUE","PROBABILITY","FORECAST_CLOSE_DATE","OWNER_USER_ID","LAST_ACTIVITY_DATE_UTC","NEXT_ACTIVITY_DATE_UTC","PIPELINE_ID","STAGE_ID","ORGANISATION_ID","TAGS"];
        $fields['Tasks'] = ["TITLE","CATEGORY_ID","DUE_DATE","COMPLETED_DATE_UTC","COMPLETED","DETAILS","STATUS","PRIORITY","PERCENT_COMPLETE","START_DATE","MILESTONE_ID","RESPONSIBLE_USER_ID","OWNER_USER_ID","DATE_CREATED_UTC","DATE_UPDATED_UTC","EMAIL_ID","PROJECT_ID","REMINDER_DATE_UTC","REMINDER_SENT","OWNER_VISIBLE","STAGE_ID","ASSIGNED_BY_USER_ID","PARENT_TASK_ID","RECURRENCE","OPPORTUNITY_ID","ASSIGNED_TEAM_ID","ASSIGNED_DATE_UTC","CREATED_USER_ID"];
        $fields['Projects'] = ["PROJECT_ID","PROJECT_NAME","STATUS","PROJECT_DETAILS","STARTED_DATE","COMPLETED_DATE","OPPORTUNITY_ID","CATEGORY_ID","PIPELINE_ID","STAGE_ID","IMAGE_URL","OWNER_USER_ID","DATE_CREATED_UTC","DATE_UPDATED_UTC","LAST_ACTIVITY_DATE_UTC","NEXT_ACTIVITY_DATE_UTC","RESPONSIBLE_USER_ID","TAGS"];
        return $fields;
    }

    public static function requiredFields ()
    {
        $fields = array();
        $fields['Contacts'] = ['FIRST_NAME'];
        $fields['Organisations'] = ['ORGANISATION_NAME'];
        $fields['Leads'] = ['LAST_NAME'];
        $fields['Opportunities'] = ['OPPORTUNITY_NAME'];
        $fields['Tasks'] = ['TITLE'];
        $fields['Projects'] = ['PROJECT_NAME','STATUS'];
        return $fields;
    }

    public static function requiredFieldsForList($list)
    {
        if (!in_array($list, static::lists())) {
            throw new \InvalidArgumentException('Invalid list name');
        }
        $fields = static::requiredFields();
        return $fields[$list];
    }

    public static function lists()
    {
        return [
            'Opportunities' => Yii::t('app', 'Opportunities'),
            'Tasks' => Yii::t('app', 'Tasks'),
            'Projects' => Yii::t('app', 'Projects'),
            'Contacts' => Yii::t('app', 'Contacts'),
            'Organisations' => Yii::t('app', 'Organisations'),
            'Leads' => Yii::t('app', 'Leads'),
        ];
    }
}