<?php

use yii\helpers\Html;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;
use kartik\file\FileInput;
use app\components\widgets\ConditionsBuilder;
use yii\web\View;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\import_submissions\models\ImportSubmissions */
/* @var $fieldModel app\modules\addons\modules\import_submissions\models\ImportSubmissionsField */
/* @var $form yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */

$formFieldUrl = Url::to(['/addons/import_submissions/admin/fields']);
$listFieldUrl = Url::to(['/addons/import_submissions/admin/list-fields']);
?>

<div class="import_submissions-form">

    <?php $form = ActiveForm::begin(); ?>

        <div class="row" style="margin-top: 20px;">
            <div class="col-sm-12">
                <?= $form->field($model, 'name')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                    'data' => $forms,
                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ])->label(Yii::t('app', 'Form')); ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'file')->widget(FileInput::class, [
                    'pluginOptions' => [
                        'showPreview' => false,
                        'showCaption' => true,
                        'showRemove' => true,
                        'showUpload' => false,
                        'showCancel' => true,
                        'layoutTemplates' => [
                            'caption' => "<div class='file-caption form-control {class}' tabindex='500'>
                                <span class='file-caption-icon'></span>
                                <input class='file-caption-name' style='width: 85%; border-color: transparent'>
                            </div>",
                        ],
                    ]
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'events')->widget(Select2::class, [
                    'data' => $model->eventTypes,
                    'options' => [
                        'multiple' => true,
                        'placeholder' => Yii::t('app', 'Select event...'),
                    ],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ])->hint(Yii::t('app', 'Trigger events when each submission is processed.')); ?>
            </div>
            <div class="col-sm-3">
                <?php if ($model->isNewRecord) { $model->run_validation = 1;} ?>
                <?= $form->field($model, 'run_validation')->widget(SwitchInput::class)->hint(Yii::t(
                    'app',
                    'Enable form validation rules.'
                )) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
            </div>
        </div>

        <?php if ($model->isNewRecord || count($model->items) === 0): ?>

            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($fieldModel, '[0]form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['importsubmissions-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, '[0]file_field')->dropDownList(
                            [],
                            [
                                'prompt' => Yii::t('app', 'Select...'),
                                'class' => 'file-fields',
                            ]
                        ); ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-add">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </fieldset>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['importsubmissions-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, 'file_field')->dropDownList(
                            [],
                            [
                                'prompt' => Yii::t('app', 'Select...'),
                                'class' => 'file-fields',
                                'disabled' => true,
                            ]
                        ); ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-remove">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </fieldset>

        <?php else: ?>

            <?php foreach($model->items as $i => $item): ?>
                <fieldset class="item">
                    <div class="row">
                        <div class="col-sm-6">
                            <?= Html::hiddenInput('item-'.$i.'-form_field',
                                $item->form_field, ['id'=>'item-'.$i.'-form_field']) ?>
                            <?= $form->field($fieldModel, '['.$i.']form_field')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['importsubmissions-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $formFieldUrl,
                                    'params'=>['item-'.$i.'-form_field'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-5">
                            <?= $form->field($fieldModel, '['.$i.']file_field')->widget(Select2::class, [
                                'options' => ['placeholder' => Yii::t('app', 'Select...')],
                                'pluginOptions' => [
                                    'allowClear' => true
                                ],
                            ]) ?>
                        </div>
                        <div class="col-sm-1">
                            <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </fieldset>
            <?php endforeach; ?>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-6">
                        <?= Html::hiddenInput('item-form_field', '', ['id'=>'item-form_field']) ?>
                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['importsubmissions-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'params'=>['item-form_field'],
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, 'file_field')->widget(Select2::class, [
                            'options' => ['placeholder' => Yii::t('app', 'Select...')],
                            'pluginOptions' => [
                                'allowClear' => true
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </fieldset>

        <?php endif; ?>

        <div class="row">
            <div class="col-sm-12">
                <legend><?= Yii::t('app', 'Advanced Settings') ?></legend>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <?= ConditionsBuilder::widget([
                    'label' => Yii::t('app', 'Conditions'),
                ]) ?>
                <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <?= $form->field($model, 'notes')->textarea([
                    'rows' => '3',
                    'style' => "height: 120px"
                ]) ?>
            </div>
        </div>

    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton(
                ' <i class="fas fa-check me-2"></i> '
                . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<?php

$this->registerCss("legend { margin-top: 20px; }");

if ($model->isNewRecord || count($model->items) === 0) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update name attribute
            cloned
                .find('[name="ImportSubmissionsField[form_field]"]')
                    .attr('name', 'ImportSubmissionsField[' + item + '][form_field]')
                    .attr('id', 'importsubmissionsfield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['importsubmissions-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="ImportSubmissionsField[file_field]"]')
                    .attr('name', 'ImportSubmissionsField[' + item + '][file_field]')
                    .attr('id', 'importsubmissionsfield-' + item + '-file_field')
                    .removeAttr('disabled')
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#importsubmissions-form_id').trigger('depdrop.change');
    $('#importsubmissions-file').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.glyphicon-minus').removeClass('glyphicon-minus').addClass('glyphicon-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update name attribute
            cloned
                .find('[name="ImportSubmissionsField[form_field]"]')
                    .attr('name', 'ImportSubmissionsField[' + item + '][form_field]')
                    .attr('id', 'importsubmissionsfield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['importsubmissions-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="ImportSubmissionsField[file_field]"]')
                    .attr('name', 'ImportSubmissionsField[' + item + '][file_field]')
                    .attr('id', 'importsubmissionsfield-' + item + '-file_field')
                    .removeAttr('disabled')
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });
    
})

JS;
}

$this->registerJs($script, $this::POS_END);

$this->registerJsFile("@web/modules/addons/modules/import_submissions/assets/import-submissions.js", [
    'position' => View::POS_END,
], 'import-submissions');

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int) !$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#importsubmissions-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['importsubmissions-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, View::POS_END, 'import_submissions');
