<?php

namespace app\modules\addons\modules\import_submissions\models;

use Yii;

/**
 * This is the model class for table "{{%addon_import_submissions_item}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property string $form_field
 * @property string $file_field
 * @property string $default_value
 */
class ImportSubmissionsField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_import_submissions_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id'], 'integer'],
            [['form_field', 'file_field'], 'string', 'max' => 255],
            [['default_value'], 'string', 'max' => 2555],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'import_submissions_id' => Yii::t('app', 'ImportSubmissions ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'file_field' => Yii::t('app', 'File Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getImportSubmissions()
    {
        return $this->hasOne(ImportSubmissions::class,['form_id'=>'form_id']);
    }
}
