<?php

namespace app\modules\addons\modules\import_submissions\models;

use app\components\behaviors\DateTrait;
use app\controllers\AppController;
use app\modules\addons\modules\import_submissions\controllers\AdminController;
use Yii;
use app\models\Form;
use app\models\User;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use app\components\behaviors\RelationTrait;

/**
 * This is the model class for table "{{%addon_import_submissions}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $status
 * @property string $name
 * @property array|string $file
 * @property integer $run_validation
 * @property string|array $events
 * @property string $note
 * @property string $data
 * @property string $invalid_data
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Form $form
 * @property ImportSubmissionsField[] $items
 * @property User $author
 * @property User $lastEditor
 * @property array $eventTypes
 */
class ImportSubmissions extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_import_submissions}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'name'], 'required'],
            [['form_id', 'status', 'run_validation', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['name', 'file', 'conditions', 'notes', 'data', 'invalid_data'], 'string'],
            [['events'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'name' => Yii::t('app', 'Name'),
            'file' => Yii::t('app', 'File'),
            'conditions' => Yii::t('app', 'Conditions'),
            'events' => Yii::t('app', 'Events'),
            'run_validation' => Yii::t('app', 'Validate'),
            'notes' => Yii::t('app', 'Notes'),
            'data' => Yii::t('app', 'Data'),
            'invalid_data' => Yii::t('app', 'Invalid Data'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @inheritdoc
     */
    public function afterFind()
    {
        $this->events = explode(',', $this->events);

        parent::afterFind();
    }

    /**
     * @inheritdoc
     */
    public function beforeValidate()
    {
        if (is_array($this->events)) {
            $this->events = implode(',', $this->events);
        }

        return parent::beforeValidate();
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(ImportSubmissionsField::class, ['form_id' => 'form_id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            // Delete all Items related to this configuration
            ImportSubmissionsField::deleteAll(["form_id" => $this->form_id]);
            return true;
        } else {
            return false;
        }
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * Return Event Types
     *
     * @return array
     */
    public function getEventTypes()
    {
        return [
            AppController::EVENT_SUBMISSION_ACCEPTED => Yii::t('app', 'Submission Accepted'),
        ];
    }
}
