<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Migration;

/**
 * Class m190703_220853_init_addon_import_submissions
 */
class m190703_220853_init_addon_import_submissions extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_import_submissions}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),
            'name' => $this->string(2555)->notNull(),

            // Settings
            'file' => $this->text(),
            'run_validation' => $this->boolean()->notNull()->defaultValue(1),
            'conditions' => $this->text(),
            'notes' => $this->text(),

            // File data
            'data' => $this->getDb()->getSchema()->createColumnSchemaBuilder('longtext'),
            'invalid_data' => $this->getDb()->getSchema()->createColumnSchemaBuilder('longtext'),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_import_submissions_field}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'form_field' => $this->text(),
            'file_field' => $this->text(),
            'default_value' => $this->text(),
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_import_submissions_field}}');
        $this->dropTable('{{%addon_import_submissions}}');
    }
}
