document.querySelector("input[type=file]").onchange = function(e) {
    var reader = new FileReader();
    var firstRowCells = [];
    reader.onload = function(event) {
        var csv = event.target.result;
        var allRows = csv.split(/\r?\n|\r/);

        for (var singleRow = 0; singleRow < allRows.length; singleRow++) {
            if (singleRow === 0) {
                $('.file-fields').empty();
            }
            var rowCells = allRows[singleRow].split(',');
            for (var rowCell = 0; rowCell < rowCells.length; rowCell++) {
                if (singleRow === 0) {
                    var value = rowCells[rowCell]
                        .replace(/^"/, '')
                        .replace(/"$/, '');
                    firstRowCells.push(value);

                    var newOption = new Option(value, rowCell.toString(), false, false);
                    $('.file-fields').append(newOption).trigger('change');
                }
            }
        }
        console.log(firstRowCells);
    }
    if (typeof e.target.files !== 'undefined'
        && typeof e.target.files[0] !== 'undefined') {
        reader.readAsText(e.target.files[0]);

        // var options = firstRowCells;
        // $('#importsubmissionsfield-0-file_field').empty();
        // $.each(options, function(i, p) {
        //     var data = {
        //         id: i,
        //         text: p
        //     };
        //     var newOption = new Option(data.text, data.id, false, false);
        //     $('#importsubmissionsfield-0-file_field').append(newOption).trigger('change');
        // });
    }
}