<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\EventHelper;
use kartik\depdrop\DepDrop;
use yii\helpers\Html;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\hubspot_forms\models\HubspotForm */
/* @var $form yii\widgets\ActiveForm */
/* @var $itemModel app\modules\addons\modules\hubspot_forms\models\HubspotFormItem */
/* @var $forms array [id => name] of Form models */

$url = Url::to(['/addons/hubspot_forms/admin/fields']);
if ($model->isNewRecord) {
    $model->status = 1;
}
?>

<div class="hubspot_form-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'placeholder' => Yii::t('app', "Enter the name..."),
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?php echo $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => [
                    'placeholder' => Yii::t('app', 'Select a form...'),
                ],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'event')->widget(Select2::class, [
                'data' => EventHelper::supportedFormEvents(),
            ]); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'url')->textInput([
                'maxlength' => true,
                'placeholder' => Yii::t('app', 'https://api.hsforms.com/submissions/v3/integration/submit/:portalId/:formGuid'),
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'context')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= ConditionsBuilder::widget([
                'label' => Yii::t('app', 'Conditions'),
            ]); ?>
            <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
        </div>
    </div>

    <?php if ($model->isNewRecord || count($model->items) === 0): ?>

        <fieldset class="item">
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($itemModel, '[0]field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['hubspotform-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, '[0]field_name')->textInput([
                        'maxlength' => true,
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-add">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['hubspotform-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'field_name')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-remove">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>

    <?php else: ?>

        <?php foreach($model->items as $i => $item): ?>
            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-6">
                        <?= Html::hiddenInput('item-'.$i.'-field_id',
                            $item->field_id, ['id'=>'item-'.$i.'-field_id']) ?>
                        <?= $form->field($item, '['.$i.']field_id')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['hubspotform-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-'.$i.'-field_id'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($item, '['.$i.']field_name')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </fieldset>
        <?php endforeach; ?>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-6">
                    <?= Html::hiddenInput('item-field_id', '', ['id'=>'item-field_id']) ?>
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['hubspotform-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                            'params'=>['item-field_id'],
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'field_name')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
        </fieldset>

    <?php endif; ?>

    <div class="row">
        <div class="col-sm-12">
            <?php if ($model->isNewRecord) { $model->consent = '{
    "consent":{
      "consentToProcess":true,
      // Boolean; Whether or not the visitor checked the Consent to process checkbox
      "text":"Text that gives consent to process",
      // String; The text displayed to the visitor for the Consent to process checkbox
      "communications":[
      // A list of details for the Consent to communicate for each subscription type included in the form
        {
          "value":true,
          // Boolean; Whether or not the visitor checked the checkbox for this subscription type.
          "subscriptionTypeId":999,
          // Integer; The ID of the specific subscription type
          "text":"Consent to communicate text for subscription type ID 999"
          // String; The text displayed to the visitor for this specific subscription checkbox
        },
        {
           "value":true,
           "subscriptionTypeId":777,
           "text":"Consent to communicate text for subscription type ID 777"
        }
      ]
    }
  }'; } ?>
            <?= $form->field($model, 'consent')->textarea(['rows' => '6'])
                ->hint(Yii::t('app', 'Customize the Legal consent options using the JSON format.')) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'tracking_code')->textarea(['rows' => '3'])
                ->hint(Yii::t('app', 'Enter the tacking code to capture the HubSpot user token.')) ?>
        </div>
    </div>


    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ?
            Yii::t('app', 'Create') :
            Yii::t('app', 'Update'),
            ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php

$this->registerCss("legend { margin-top: 20px; }");

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int) !$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#hubspotform-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['hubspotform-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'hubspot_forms');

if ($model->isNewRecord || count($model->items) === 0) {

    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="HubspotFormItem[field_id]"]')
                    .attr('name', 'HubspotFormItem[' + item + '][field_id]')
                    .attr('id', 'hubspotformitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['hubspotform-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="HubspotFormItem[field_name]"]')
                    .attr('name', 'HubspotFormItem[' + item + '][field_name]')
                    .attr('id', 'hubspotformitem-' + item + '-field_name')
                    .removeAttr('disabled')
                    .end()
                .find('textarea')
                    .removeAttr('disabled')
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#neverbounce-form_id').trigger('depdrop.change');
});     

$(document).ready(function(){
    
    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.glyphicon-minus').removeClass('glyphicon-minus').addClass('glyphicon-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update the name attributes
            cloned
                .find('[name="HubspotFormItem[field_id]"]')
                    .attr('name', 'HubspotFormItem[' + item + '][field_id]')
                    .attr('id', 'hubspotformitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['hubspotform-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('#item-field_id')
                    .attr('name', 'item-' + item + '-field_id')
                    .attr('id', 'item-' + item + '-field_id')
                    .end()
                .find('[name="HubspotFormItem[field_name]"]')
                    .attr('name', 'HubspotFormItem[' + item + '][field_name]')
                    .attr('id', 'hubspotformitem-' + item + '-field_name')
                    .removeAttr('disabled')
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

}


$this->registerJs($script, $this::POS_END);
?>

