<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\hubspot_forms\models;

use Yii;

/**
 * This is the model class for table "{{%addon_hubspot_forms_item}}".
 *
 * @property int $id
 * @property int|null $hubspot_forms_id
 * @property int|null $form_id
 * @property string|null $field_id
 * @property string|null $field_name
 */
class HubspotFormItem extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_hubspot_forms_item}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['hubspot_forms_id', 'form_id'], 'integer'],
            [['field_id', 'field_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'hubspot_forms_id' => Yii::t('app', 'HubSpot Forms ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'field_id' => Yii::t('app', 'Field'),
            'field_name' => Yii::t('app', 'HubSpot Form Field Name'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getHubspotForms()
    {
        return $this->hasOne(HubspotForm::class, ['id' => 'hubspot_forms_id']);
    }
}