<?php

use yii\db\Migration;

/**
 * Class m210809_225534_hubspot_forms_1_0
 */
class m210809_225534_hubspot_forms_1_0 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_hubspot_forms}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),

            'name' => $this->text()->notNull(),
            'event' => $this->integer()->notNull()->defaultValue(1),
            'conditions' => $this->text(),

            'url' => $this->string(2083)->notNull(),
            'context' => $this->boolean()->notNull()->defaultValue(0),
            'consent' => $this->text(),
            'tracking_code' => $this->text(),

            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_hubspot_forms_item}}', [
            'id' => $this->primaryKey(),
            'hubspot_forms_id' => $this->integer(11),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(), // Form Field ID
            'field_name' => $this->text(), // HubSpot Field Name
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_hubspot_forms_item}}');
        $this->dropTable('{{%addon_hubspot_forms}}');
    }
}
