<?php

use app\components\widgets\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = Yii::t('app', 'Integration Settings');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Google Sheets'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $this->title];

?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                        <div class="well">
                            <h5 style="font-weight: bold"><?= Yii::t('app', 'Instructions') ?></h5>
                            <ol>
                                <li><?= Yii::t('app', 'Go to {google_console} and create a {new_project}.', [
                                        'google_console' => Html::a(Yii::t('app', 'Google Developer Console'), 'https://console.cloud.google.com/'),
                                        'new_project' => Html::tag('strong', Yii::t('app', 'New Project')),
                                    ]) ?></li>
                                <li><?= Yii::t('app', 'Go to <strong>Library</strong> side menu and search <strong>Google Sheets API</strong>, open it and click <strong>Enable</strong>.') ?></li>
                                <li><?= Yii::t('app', 'Go to <strong>Library</strong> side menu and search <strong>Google Drive API</strong>, open it and click <strong>Enable</strong>.') ?></li>
                                <li><?= Yii::t('app', 'Go to <strong>OAuth consent screen</strong>, enter "{application_name}" on <strong>Application name</strong>, enter {application_domain} in <strong>Authorized domains</strong> then click <strong>Save</strong> button.', [
                                        'application_name' => Html::tag('em', Yii::$app->settings->get('app.name')),
                                        'application_domain' => Html::tag('em', parse_url(Url::base(true), PHP_URL_HOST)),
                                    ]) ?></li>
                                <li><?= Yii::t('app', 'Go to <strong>Credentials</strong>, click <strong>Create Credentials</strong>, select <strong>OAuth Client ID</strong>, select application type as <strong>Web application</strong>, click <strong>Create</strong>, enter anything in <strong>Name</strong>, save {redirect_url} in <strong>Authorized redirect URIs</strong>, click <strong>Create</strong>.', [
                                        'redirect_url' => Html::tag('em', Url::to(['/addons/google_sheets/admin/authorized'], true)),
                                    ]) ?></li>
                                <li><?= Yii::t('app', 'Copy <strong>Client ID</strong> and <strong>Client Secret</strong> from newly created app and save below.') ?></li>
                                <li><?= Yii::t('app', 'Click <strong>Save & Authorize</strong>, if appears <strong>App is not verified error</strong>, click <strong>show advanced</strong> and then <strong>Go to App</strong>.') ?></li>
                            </ol>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group">
                                    <?= Html::label(Yii::t('app', 'Client ID'), 'addon_google_sheets_clientId', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'addon_google_sheets_clientId', Yii::$app->settings->get('addon_google_sheets.clientId'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group">
                                    <?= Html::label(Yii::t('app', 'Client Secret'), 'addon_google_sheets.clientSecret', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'addon_google_sheets_clientSecret', Yii::$app->settings->get('addon_google_sheets.clientSecret'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group" style="margin-top: 20px">
                                    <?= Html::hiddenInput('action', 'global-settings'); ?>
                                    <?= Html::submitButton(Html::tag('i', '', [
                                            'class' => 'fas fa-check me-2',
                                        ]) . ' ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                </div>
                            </div>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>