<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\EventHelper;
use yii\helpers\Html;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\google_sheets\models\GoogleSheets */
/* @var $itemModel app\modules\addons\modules\google_sheets\models\GoogleSheetsItem */
/* @var $forms array [id => name] of Form models */
/* @var $spreadsheets array [id => name] of Google Spreadsheets */
/* @var $token array Google Access Token */

$formFieldUrl = Url::to(['/addons/google_sheets/admin/fields']);
$sheetsUrl = Url::to(['/addons/google_sheets/admin/sheets']);
$columnsUrl = Url::to(['/addons/google_sheets/admin/columns']);

?>

<?php if (empty($token)): ?>

    <?php if ($model->isNewRecord): ?>
        <p><?= Yii::t('app', 'Authenticate your Google Sheets account to create an integration.') ?></p>
        <p><a href="<?= Url::to(['/addons/google_sheets/admin/authorize']) ?>" class="btn btn-primary"><?= Yii::t('app', 'Authenticate') ?></a></p>
    <?php else: ?>
        <p><?= Yii::t('app', 'Authenticate your Google Sheets account to update your integration.') ?></p>
        <p><a href="<?= Url::to(['/addons/google_sheets/admin/authorize', 'id' => $model->id]) ?>" class="btn btn-primary"><?= Yii::t('app', 'Authenticate') ?></a></p>
    <?php endif; ?>

<?php else: ?>

    <?php $form = ActiveForm::begin(); ?>

    <div class="row" style="margin-top: 20px;">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'spreadsheet_id')->widget(Select2::class, [
                'data' => $spreadsheets,
                'options' => [
                    'placeholder' => Yii::t('app', 'Select a spreadsheet...'),
                ],
                'pluginOptions' => [
                    'allowClear' => true
                ]
            ])->hint( Yii::t(
                'app',
                'Select the spreadsheet you want to add information to.'
            ))->label(Yii::t('app', 'Spreadsheet')); ?>
        </div>
        <div class="col-sm-3">
            <?php if (!$model->isNewRecord): ?>
            <?= Html::hiddenInput('item-sheet_id', $model->sheet_id, ['id'=>'item-sheet_id']) ?>
            <?php endif; ?>
            <?= $form->field($model, 'sheet_id')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['googlesheets-spreadsheet_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $sheetsUrl,
                    'initialize' => !$model->isNewRecord,
                    'params'=>['item-sheet_id', 'googlesheets-form_id'],
                    'loading' => false,
                ],
            ])->hint( Yii::t(
                'app',
                'Select the sheet you want to add information to.'
            ))->label(Yii::t('app', 'Sheet')); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'event')->widget(Select2::class, [
                'data' => EventHelper::supportedFormEvents(),
            ]); ?>
        </div>
        <div class="col-sm-6">
            <?php if ($model->isNewRecord) { $model->status = 1;} ?>
            <?= $form->field($model, 'status')->widget(SwitchInput::class)->hint(Yii::t(
                'app',
                'Disables the integration at any time.'
            )) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= ConditionsBuilder::widget([
                'label' => Yii::t('app', 'Conditions'),
            ]) ?>
            <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
        </div>
    </div>

    <?php if ($model->isNewRecord || count($model->items) === 0): ?>

        <fieldset class="item">
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($itemModel, '[0]field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['googlesheets-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $formFieldUrl,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, '[0]column_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['googlesheets-spreadsheet_id', 'googlesheets-sheet_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $columnsUrl,
                            'params'=>['googlesheets-form_id'],
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-add">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['googlesheets-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $formFieldUrl,
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'column_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['googlesheets-spreadsheet_id', 'googlesheets-sheet_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $columnsUrl,
                            'params'=>['googlesheets-form_id'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
        </fieldset>

    <?php else: ?>

        <?php foreach($model->items as $i => $item): ?>
            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-6">
                        <?= Html::hiddenInput('item-'.$i.'-field_id',
                            $item->field_id, ['id'=>'item-'.$i.'-field_id']) ?>
                        <?= $form->field($itemModel, '['.$i.']field_id')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['googlesheets-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'params'=>['item-'.$i.'-field_id'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= Html::hiddenInput('item-'.$i.'-column_id', $item->column_id, ['id'=>'item-'.$i.'-column_id']) ?>
                        <?= $form->field($itemModel, '['.$i.']column_id')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['googlesheets-spreadsheet_id', 'googlesheets-sheet_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $columnsUrl,
                                'params' => ['item-'.$i.'-column_id', 'googlesheets-form_id']
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </fieldset>
        <?php endforeach; ?>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-6">
                    <?= Html::hiddenInput('item-field_id', '', ['id'=>'item-field_id']) ?>
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['googlesheets-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $formFieldUrl,
                            'params'=>['item-field_id'],
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= Html::hiddenInput('item-column_id', '', ['id'=>'item-column_id']) ?>
                    <?= $form->field($itemModel, 'column_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['googlesheets-spreadsheet_id', 'googlesheets-sheet_id'],
                            'initialize' => true,
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $columnsUrl,
                            'params'=>['item-column_id', 'googlesheets-form_id'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
        </fieldset>

    <?php endif; ?>

    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton(
                ' <i class="fas fa-check"></i> ' .
                Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

<?php endif; ?>

<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

if ($token) {

    $script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#googlesheets-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['googlesheets-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

    $this->registerJs($script, $this::POS_END, 'googlesheets-conditions');

}

/**
 * Field Mapping
 */

if ($model->isNewRecord || count($model->items) === 0) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update name attribute
            cloned
                .find('[name="GoogleSheetsItem[field_id]"]')
                    .attr('name', 'GoogleSheetsItem[' + item + '][field_id]')
                    .attr('id', 'googlesheetsitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googlesheets-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="GoogleSheetsItem[column_id]"]')
                    .attr('name', 'GoogleSheetsItem[' + item + '][column_id]')
                    .attr('id', 'googlesheetsitem-' + item + '-column_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googlesheets-spreadsheet_id'],
                        url: '$sheetsUrl'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#googlesheets-form_id').trigger('depdrop.change');
    $('#googlesheets-spreadsheet_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update name attribute
            cloned
                .find('[name="GoogleSheetsItem[field_id]"]')
                    .attr('name', 'GoogleSheetsItem[' + item + '][field_id]')
                    .attr('id', 'googlesheetsitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googlesheets-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="GoogleSheetsItem[column_id]"]')
                    .attr('name', 'GoogleSheetsItem[' + item + '][column_id]')
                    .attr('id', 'googlesheetsitem-' + item + '-column_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googlesheets-spreadsheet_id'],
                        url: '{$sheetsUrl}'
                    })
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
}

$this->registerJs($script, $this::POS_END);

?>
