<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\google_sheets\models;

use Yii;

/**
 * This is the model class for table "{{%addon_google_sheets_item}}".
 *
 * @property int $id
 * @property int|null $google_sheets_id
 * @property int|null $form_id
 * @property string|null $field_id
 * @property string|null $column_id
 */
class GoogleSheetsItem extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_google_sheets_item}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['google_sheets_id', 'form_id'], 'integer'],
            [['field_id', 'column_id'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'google_sheets_id' => Yii::t('app', 'Google Sheets ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'field_id' => Yii::t('app', 'Field'),
            'column_id' => Yii::t('app', 'Column'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGoogleSheets()
    {
        return $this->hasOne(GoogleSheets::class, ['id' => 'google_sheets_id']);
    }
}