<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\google_sheets\models;

use app\models\User;
use Yii;
use app\models\Form;
use app\components\behaviors\RelationTrait;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use app\components\behaviors\DateTrait;

/**
 * This is the model class for table "{{%addon_google_sheets}}".
 *
 * @property int $id
 * @property int $form_id
 * @property int $status
 * @property string $name
 * @property int $event
 * @property string|null $conditions
 * @property string|null $oauth
 * @property string|null $spreadsheet_id
 * @property string|null $sheet_id
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property int|null $created_at
 * @property int|null $updated_at
 *
 * @property Form $form
 * @property GoogleSheetsItem[] $items
 */
class GoogleSheets extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const OFF = 0;
    const ON = 1;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_google_sheets}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['form_id', 'name', 'spreadsheet_id', 'sheet_id'], 'required'],
            [['form_id', 'status', 'event', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['conditions', 'oauth'], 'string'],
            [['name', 'spreadsheet_id', 'sheet_id'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'name' => Yii::t('app', 'Name'),
            'event' => Yii::t('app', 'Event'),
            'conditions' => Yii::t('app', 'Conditions'),
            'oauth' => Yii::t('app', 'Oauth'),
            'spreadsheet_id' => Yii::t('app', 'Spreadsheet ID'),
            'sheet_id' => Yii::t('app', 'Sheet ID'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }


    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(GoogleSheetsItem::class, ['google_sheets_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            GoogleSheetsItem::deleteAll(["google_sheets_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }
}