<?php

use yii\db\Migration;

/**
 * Class m210410_205035_google_sheets_1_0
 */
class m210410_205035_google_sheets_1_0 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%addon_google_sheets}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),

            'name' => $this->text()->notNull(),
            'event' => $this->integer()->notNull()->defaultValue(1),
            'conditions' => $this->text(),

            'oauth' => $this->text(),
            'spreadsheet_id' => $this->text(),
            'sheet_id' => $this->text(),

            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ]);

        $this->createTable('{{%addon_google_sheets_item}}', [
            'id' => $this->primaryKey(),
            'google_sheets_id' => $this->integer(11),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(), // Form Field ID
            'column_id' => $this->text(), // Spreadsheet Column ID
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_google_sheets_item}}');
        $this->dropTable('{{%addon_google_sheets}}');
    }

}
