<?php

use yii\helpers\Html;
use yii\helpers\Url;
use app\helpers\Country;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\google_places_autocomplete\models\GooglePlacesAutoComplete */
/* @var $itemModel app\modules\addons\modules\google_places_autocomplete\models\GooglePlacesAutoCompleteItem */
/* @var $forms array [id => name] of Form models */

$this->title = Yii::t('app', 'Update Form');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Google Places Autocomplete'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Form') .' #'.
    $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('app', 'Update');

$url = Url::to(['/addons/google_places_autocomplete/admin/fields']);
$types = [
    '' => Yii::t('app', 'Select'),
    'geocode' => Yii::t('app', 'Geocode'),
    'address' => Yii::t('app', 'Address'),
    'regions' => Yii::t('app', 'Regions'),
    'establishment' => Yii::t('app', 'Establishment'),
];
$countries = array_merge(['' => Yii::t('app', 'Select')], Country::all());
$showMarker = [
    '' => Yii::t('app', 'Select'),
    $model::ON => Yii::t('app', 'Yes'),
    $model::OFF => Yii::t('app', 'No'),
];
?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin([
                            'options' => ['enctype' => 'multipart/form-data']
                        ]); ?>
                        <div class="row">
                            <div class="col-sm-6">
                                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                                    'data' => $forms,
                                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label(Yii::t('app', 'Form')); ?>
                            </div>
                            <div class="col-sm-6">
                                <?= $form->field($model, 'api_key')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-3">
                                <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'geolocation')->widget(SwitchInput::class) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <legend><?= Yii::t('app', 'Items') ?></legend>
                            </div>
                        </div>
                        <?php foreach($model->items as $i => $item): ?>
                            <fieldset class="item">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <?= Html::hiddenInput('item-'.$i.'-field_id',
                                            $item->field_id, ['id'=>'item-'.$i.'-field_id']) ?>
                                        <?= $form->field($item, '['.$i.']field_id')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-field_id'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= $form->field($item, '['.$i.']type')->dropDownList($types); ?>
                                    </div>
                                    <div class="col-sm-2">
                                        <?= $form->field($item, '['.$i.']country')->dropDownList($countries); ?>
                                    </div>
                                    <div class="col-sm-1">
                                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-route_field',
                                            $item->route_field, ['id'=>'item-'.$i.'-route_field']) ?>
                                        <?= $form->field($item, '['.$i.']route_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-route_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-street_number_field',
                                            $item->street_number_field, ['id'=>'item-'.$i.'-street_number_field']) ?>
                                        <?= $form->field($item, '['.$i.']street_number_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-street_number_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-sublocality_level_1_field',
                                            $item->sublocality_level_1_field, ['id'=>'item-'.$i.'-sublocality_level_1_field']) ?>
                                        <?= $form->field($item, '['.$i.']sublocality_level_1_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-sublocality_level_1_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-sublocality_level_2_field',
                                            $item->sublocality_level_2_field, ['id'=>'item-'.$i.'-sublocality_level_2_field']) ?>
                                        <?= $form->field($item, '['.$i.']sublocality_level_2_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-sublocality_level_2_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-locality_field',
                                            $item->locality_field, ['id'=>'item-'.$i.'-locality_field']) ?>
                                        <?= $form->field($item, '['.$i.']locality_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-locality_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-administrative_area_level_1_field',
                                            $item->administrative_area_level_1_field, ['id'=>'item-'.$i.'-administrative_area_level_1_field']) ?>
                                        <?= $form->field($item, '['.$i.']administrative_area_level_1_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-administrative_area_level_1_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-administrative_area_level_2_field',
                                            $item->administrative_area_level_2_field, ['id'=>'item-'.$i.'-administrative_area_level_2_field']) ?>
                                        <?= $form->field($item, '['.$i.']administrative_area_level_2_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-administrative_area_level_2_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-administrative_area_level_3_field',
                                            $item->administrative_area_level_3_field, ['id'=>'item-'.$i.'-administrative_area_level_3_field']) ?>
                                        <?= $form->field($item, '['.$i.']administrative_area_level_3_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-administrative_area_level_3_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-postal_code_field',
                                            $item->postal_code_field, ['id'=>'item-'.$i.'-postal_code_field']) ?>
                                        <?= $form->field($item, '['.$i.']postal_code_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-postal_code_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-country_field',
                                            $item->country_field, ['id'=>'item-'.$i.'-country_field']) ?>
                                        <?= $form->field($item, '['.$i.']country_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-country_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-country_code_field',
                                            $item->country_code_field, ['id'=>'item-'.$i.'-country_code_field']) ?>
                                        <?= $form->field($item, '['.$i.']country_code_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-country_code_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-latitude_field',
                                            $item->latitude_field, ['id'=>'item-'.$i.'-latitude_field']) ?>
                                        <?= $form->field($item, '['.$i.']latitude_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-latitude_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= Html::hiddenInput('item-'.$i.'-longitude_field',
                                            $item->longitude_field, ['id'=>'item-'.$i.'-longitude_field']) ?>
                                        <?= $form->field($item, '['.$i.']longitude_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['googleplacesautocomplete-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $url,
                                                'params'=>['item-'.$i.'-longitude_field'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= $form->field($item, '['.$i.']map_selector')->textInput([
                                            'maxlength' => true,
                                            'placeholder' => Yii::t('app', 'Eg. map'),
                                        ])->label(Yii::t('app', 'Map Selector')
                                            . ' '
                                            . Html::tag('small', Html::tag('span', '', [
                                                'class' => 'fas fa-question-circle',
                                                'style' => '',
                                            ]), [
                                                'data-toggle' => 'tooltip',
                                                'data-placement'=> 'top',
                                                'title' => Yii::t(
                                                    'app',
                                                    "To embed a map on your form, add the following HTML code to your form: <div id='map'></div>, then use the ID as selector: map."
                                                ),
                                                'class' => 'text'
                                            ])
                                        ) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= $form->field($item, '['.$i.']map_zoom')->textInput([
                                            'type' => 'number',
                                            'min' => 0,
                                            'max' => 22,
                                            'step' => 1,
                                            'maxlength' => true,
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-3">
                                        <?= $form->field($item, '['.$i.']map_marker')->dropDownList($showMarker); ?>
                                    </div>
                                </div>
                            </fieldset>
                        <?php endforeach; ?>
                        <fieldset id="itemTemplate" class="d-none">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= Html::hiddenInput('item-field_id', '', ['id'=>'item-field_id']) ?>
                                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-field_id'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'type')->dropDownList($types, ['disabled' => true]); ?>
                                </div>
                                <div class="col-sm-2">
                                    <?= $form->field($itemModel, 'country')->dropDownList($countries, ['disabled' => true]); ?>
                                </div>
                                <div class="col-sm-1">
                                    <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-route_field', '', ['id'=>'item-route_field']) ?>
                                    <?= $form->field($itemModel, 'route_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-route_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-street_number_field', '', ['id'=>'item-street_number_field']) ?>
                                    <?= $form->field($itemModel, 'street_number_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-street_number_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-sublocality_level_1_field', '', ['id'=>'item-sublocality_level_1_field']) ?>
                                    <?= $form->field($itemModel, 'sublocality_level_1_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-sublocality_level_1_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-sublocality_level_2_field', '', ['id'=>'item-sublocality_level_2_field']) ?>
                                    <?= $form->field($itemModel, 'sublocality_level_2_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-sublocality_level_2_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-locality_field', '', ['id'=>'item-locality_field']) ?>
                                    <?= $form->field($itemModel, 'locality_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-locality_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-administrative_area_level_1_field', '', ['id'=>'item-administrative_area_level_1_field']) ?>
                                    <?= $form->field($itemModel, 'administrative_area_level_1_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-administrative_area_level_1_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-administrative_area_level_2_field', '', ['id'=>'item-administrative_area_level_2_field']) ?>
                                    <?= $form->field($itemModel, 'administrative_area_level_2_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-administrative_area_level_2_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-administrative_area_level_3_field', '', ['id'=>'item-administrative_area_level_3_field']) ?>
                                    <?= $form->field($itemModel, 'administrative_area_level_3_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-administrative_area_level_3_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-postal_code_field', '', ['id'=>'item-postal_code_field']) ?>
                                    <?= $form->field($itemModel, 'postal_code_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-postal_code_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-country_field', '', ['id'=>'item-country_field']) ?>
                                    <?= $form->field($itemModel, 'country_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-country_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-country_code_field', '', ['id'=>'item-country_code_field']) ?>
                                    <?= $form->field($itemModel, 'country_code_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-country_code_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-latitude_field', '', ['id'=>'item-latitude_field']) ?>
                                    <?= $form->field($itemModel, 'latitude_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-latitude_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= Html::hiddenInput('item-longitude_field', '', ['id'=>'item-longitude_field']) ?>
                                    <?= $form->field($itemModel, 'longitude_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                            'params'=>['item-longitude_field'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'map_selector')->textInput([
                                        'maxlength' => true,
                                        'disabled' => true,
                                        'placeholder' => Yii::t('app', 'Eg. map'),
                                    ])->label(Yii::t('app', 'Map Selector')
                                        . ' '
                                        . Html::tag('small', Html::tag('span', '', [
                                            'class' => 'fas fa-question-circle',
                                            'style' => '',
                                        ]), [
                                            'data-toggle' => 'tooltip',
                                            'data-placement'=> 'top',
                                            'title' => Yii::t(
                                                'app',
                                                "To embed a map on your form, add the following HTML code to your form: <div id='map'></div>, then use the ID as selector: map."
                                            ),
                                            'class' => 'text'
                                        ])
                                    ) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'map_zoom')->textInput([
                                        'type' => 'number',
                                        'disabled' => true,
                                        'min' => 0,
                                        'max' => 22,
                                        'step' => 1,
                                        'maxlength' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'map_marker')->dropDownList($showMarker, ['disabled' => true]); ?>
                                </div>
                            </div>
                        </fieldset>
                        <div class="form-group">
                            <?= Html::submitButton(Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

$this->registerCss("legend { margin-top: 20px; }");

$script = <<<JS

$(window).on('load', function() {
    $('#googleplacesautocomplete-form_id').trigger('depdrop.change');
});     

$(document).ready(function(){
    
    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update the name attributes
            cloned
                .find('[name="GooglePlacesAutoCompleteItem[field_id]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][field_id]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-field_id')
                    .attr('name', 'item-' + item + '-field_id')
                    .attr('id', 'item-' + item + '-field_id')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[type]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][type]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-type')
                    .removeAttr('disabled')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[country]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][country]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-country')
                    .removeAttr('disabled')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[route_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][route_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-route_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-route_field')
                    .attr('name', 'item-' + item + '-route_field')
                    .attr('id', 'item-' + item + '-route_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[street_number_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][street_number_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-street_number_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-street_number_field')
                    .attr('name', 'item-' + item + '-street_number_field')
                    .attr('id', 'item-' + item + '-street_number_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[sublocality_level_1_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][sublocality_level_1_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-sublocality_level_1_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-sublocality_level_1_field')
                    .attr('name', 'item-' + item + '-sublocality_level_1_field')
                    .attr('id', 'item-' + item + '-sublocality_level_1_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[sublocality_level_2_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][sublocality_level_2_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-sublocality_level_2_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-sublocality_level_2_field')
                    .attr('name', 'item-' + item + '-sublocality_level_2_field')
                    .attr('id', 'item-' + item + '-sublocality_level_2_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[locality_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][locality_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-locality_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-locality_field')
                    .attr('name', 'item-' + item + '-locality_field')
                    .attr('id', 'item-' + item + '-locality_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[administrative_area_level_1_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][administrative_area_level_1_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-administrative_area_level_1_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-administrative_area_level_1_field')
                    .attr('name', 'item-' + item + '-administrative_area_level_1_field')
                    .attr('id', 'item-' + item + '-administrative_area_level_1_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[administrative_area_level_2_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][administrative_area_level_2_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-administrative_area_level_2_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-administrative_area_level_2_field')
                    .attr('name', 'item-' + item + '-administrative_area_level_2_field')
                    .attr('id', 'item-' + item + '-administrative_area_level_2_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[administrative_area_level_3_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][administrative_area_level_3_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-administrative_area_level_3_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-administrative_area_level_3_field')
                    .attr('name', 'item-' + item + '-administrative_area_level_3_field')
                    .attr('id', 'item-' + item + '-administrative_area_level_3_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[postal_code_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][postal_code_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-postal_code_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-postal_code_field')
                    .attr('name', 'item-' + item + '-postal_code_field')
                    .attr('id', 'item-' + item + '-postal_code_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[country_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][country_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-country_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-country_field')
                    .attr('name', 'item-' + item + '-country_field')
                    .attr('id', 'item-' + item + '-country_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[country_code_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][country_code_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-country_code_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-country_code_field')
                    .attr('name', 'item-' + item + '-country_code_field')
                    .attr('id', 'item-' + item + '-country_code_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[latitude_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][latitude_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-latitude_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-latitude_field')
                    .attr('name', 'item-' + item + '-latitude_field')
                    .attr('id', 'item-' + item + '-latitude_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[longitude_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][longitude_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-longitude_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-longitude_field')
                    .attr('name', 'item-' + item + '-longitude_field')
                    .attr('id', 'item-' + item + '-longitude_field')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[map_selector]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][map_selector]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-map_selector')
                    .removeAttr('disabled')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[map_zoom]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][map_zoom]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-map_zoom')
                    .removeAttr('disabled')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[map_marker]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][map_marker]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-map_marker')
                    .removeAttr('disabled')
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
$this->registerJs($script, $this::POS_END);
?>