<?php

use yii\helpers\Html;
use yii\helpers\Url;
use app\helpers\Country;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\google_places_autocomplete\models\GooglePlacesAutocomplete */
/* @var $itemModel app\modules\addons\modules\google_places_autocomplete\models\GooglePlacesAutocompleteItem */
/* @var $forms array [id => name] of Form models */

$this->title = Yii::t('app', 'Set Up a Form');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Google Places Autocomplete'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$url = Url::to(['/addons/google_places_autocomplete/admin/fields']);
$model->status = 1;
$types = [
	'' => Yii::t('app', 'Select'),
	'geocode' => Yii::t('app', 'Geocode'),
	'address' => Yii::t('app', 'Address'),
	'regions' => Yii::t('app', 'Regions'),
	'establishment' => Yii::t('app', 'Establishment'),
];
$countries = array_merge(['' => Yii::t('app', 'Select')], Country::all());
$showMarker = [
    '' => Yii::t('app', 'Select'),
    $model::ON => Yii::t('app', 'Yes'),
    $model::OFF => Yii::t('app', 'No'),
];
?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(); ?>
                        <div class="row">
                            <div class="col-sm-6">
                                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                                    'data' => $forms,
                                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label(Yii::t('app', 'Form')); ?>
                            </div>
                            <div class="col-sm-6">
                                <?= $form->field($model, 'api_key')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-3">
                                <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'geolocation')->widget(SwitchInput::class) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <legend><?= Yii::t('app', 'Fields') ?></legend>
                            </div>
                        </div>
                        <fieldset class="item">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($itemModel, '[0]field_id')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]type')->dropDownList($types); ?>
                                </div>
                                <div class="col-sm-2">
                                    <?= $form->field($itemModel, '[0]country')->dropDownList($countries); ?>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="padding-top: 28px;">
                                        <button type="button" class="btn btn-icon btn-default btn-add">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]route_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]street_number_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]sublocality_level_1_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]sublocality_level_2_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]locality_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]administrative_area_level_1_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]administrative_area_level_2_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]administrative_area_level_3_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]postal_code_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]country_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]country_code_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]latitude_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]longitude_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]map_selector')->textInput([
                                        'maxlength' => true,
                                        'placeholder' => Yii::t('app', 'Eg. map'),
                                    ])->label(Yii::t('app', 'Map Selector')
                                        . ' '
                                        . Html::tag('small', Html::tag('span', '', [
                                            'class' => 'fas fa-question-circle',
                                            'style' => '',
                                        ]), [
                                            'data-toggle' => 'tooltip',
                                            'data-placement'=> 'top',
                                            'title' => Yii::t(
                                                'app',
                                                "To embed a map on your form, add the following HTML code to your form: <div id='map'></div>, then use the ID as selector: map."
                                            ),
                                            'class' => 'text'
                                        ])
                                    ) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]map_zoom')->textInput([
                                        'type' => 'number',
                                        'min' => 0,
                                        'max' => 22,
                                        'step' => 1,
                                        'maxlength' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]map_marker')->dropDownList($showMarker); ?>
                                </div>
                            </div>
                        </fieldset>
                        <fieldset id="itemTemplate" class="d-none">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'type')->dropDownList($types, ['disabled' => true]); ?>
                                </div>
                                <div class="col-sm-2">
                                    <?= $form->field($itemModel, 'country')->dropDownList($countries, ['disabled' => true]); ?>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="padding-top: 28px;">
                                        <button type="button" class="btn btn-icon btn-default btn-remove">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'route_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'street_number_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'sublocality_level_1_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'sublocality_level_2_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'locality_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'administrative_area_level_1_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'administrative_area_level_2_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'administrative_area_level_3_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'postal_code_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'country_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'country_code_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'latitude_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'longitude_field')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['googleplacesautocomplete-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                                $(event.currentTarget).attr('disabled', true)
                                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'map_selector')->textInput([
                                        'maxlength' => true,
                                        'disabled' => true,
                                        'placeholder' => Yii::t('app', 'Eg. map'),
                                    ])->label(Yii::t('app', 'Map Selector')
                                        . ' '
                                        . Html::tag('small', Html::tag('span', '', [
                                            'class' => 'fas fa-question-circle',
                                            'style' => '',
                                        ]), [
                                            'data-toggle' => 'tooltip',
                                            'data-placement'=> 'top',
                                            'title' => Yii::t(
                                                'app',
                                                "To embed a map on your form, add the following HTML code to your form: <div id='map'></div>, then use the ID as selector: map."
                                            ),
                                            'class' => 'text'
                                        ])
                                    ) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'map_zoom')->textInput([
                                        'type' => 'number',
                                        'disabled' => true,
                                        'min' => 0,
                                        'max' => 22,
                                        'step' => 1,
                                        'maxlength' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'map_marker')->dropDownList($showMarker, ['disabled' => true]); ?>
                                </div>
                            </div>
                        </fieldset>
                        <div class="form-group">
                            <?= Html::submitButton($model->isNewRecord ?
                                Yii::t('app', 'Save') :
                                Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php

$this->registerCss("legend { margin-top: 20px; }");

$script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="GooglePlacesAutoCompleteItem[field_id]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][field_id]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[type]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][type]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-type')
                    .removeAttr('disabled')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[country]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][country]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-country')
                    .removeAttr('disabled')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[route_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][route_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-route_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[street_number_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][street_number_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-street_number_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[sublocality_level_1_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][sublocality_level_1_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-sublocality_level_1_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[sublocality_level_1_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][sublocality_level_1_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-sublocality_level_1_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[sublocality_level_2_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][sublocality_level_2_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-sublocality_level_2_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[administrative_area_level_1_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][administrative_area_level_1_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-administrative_area_level_1_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[administrative_area_level_2_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][administrative_area_level_2_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-administrative_area_level_2_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[administrative_area_level_3_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][administrative_area_level_3_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-administrative_area_level_3_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[postal_code_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][postal_code_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-postal_code_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[country_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][country_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-country_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[country_code_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][country_code_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-country_code_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[latitude_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][latitude_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-latitude_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[longitude_field]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][longitude_field]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-longitude_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['googleplacesautocomplete-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[map_selector]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][map_selector]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-map_selector')
                    .removeAttr('disabled')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[map_zoom]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][map_zoom]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-map_zoom')
                    .removeAttr('disabled')
                    .end()
                .find('[name="GooglePlacesAutoCompleteItem[map_marker]"]')
                    .attr('name', 'GooglePlacesAutoCompleteItem[' + item + '][map_marker]')
                    .attr('id', 'googleplacesautocompleteitem-' + item + '-map_marker')
                    .removeAttr('disabled')
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
$this->registerJs($script, $this::POS_END);

$js = <<< 'SCRIPT'

$(function () {
    $("[data-toggle='tooltip']").tooltip();
});;

SCRIPT;
// Register tooltip/popover initialization javascript
$this->registerJs($js, $this::POS_END);
