<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\google_places_autocomplete\models;

use Yii;

/**
 * This is the model class for table "{{%addon_google_places_autocomplete_item}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property string $field_id
 * @property string $type
 * @property string $country
 * @property string $route_field
 * @property string $street_number_field
 * @property string $locality_field
 * @property string $sublocality_level_1_field
 * @property string $sublocality_level_2_field
 * @property string $administrative_area_level_1_field
 * @property string $administrative_area_level_2_field
 * @property string $administrative_area_level_3_field
 * @property string $postal_code_field
 * @property string $country_field
 * @property string $country_code_field
 * @property string $latitude_field
 * @property string $longitude_field
 * @property string $map_selector
 * @property string $map_zoom
 * @property integer $map_marker
 */
class GooglePlacesAutoCompleteItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_google_places_autocomplete_item}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'map_zoom', 'map_marker'], 'integer'],
            [['field_id', 'type', 'country'], 'string', 'max' => 255],
            [['route_field', 'street_number_field', 'locality_field', 'sublocality_level_1_field', 'sublocality_level_2_field',
                'administrative_area_level_1_field', 'administrative_area_level_2_field', 'administrative_area_level_3_field',
                'postal_code_field', 'country_field', 'country_code_field',
                'latitude_field', 'longitude_field', 'map_selector'], 'string', 'max' => 45],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form'),
            'field_id' => Yii::t('app', 'Autocomplete'),
            'type' => Yii::t('app', 'Type Restriction'),
            'country' => Yii::t('app', 'Country Restriction'),
            'route_field' => Yii::t('app', 'Route'),
            'street_number_field' => Yii::t('app', 'Street Number'),
            'locality_field' => Yii::t('app', 'Locality'),
            'sublocality_level_1_field' => Yii::t('app', 'Sub-Locality Level 1'),
            'sublocality_level_2_field' => Yii::t('app', 'Sub-Locality Level 2'),
            'administrative_area_level_1_field' => Yii::t('app', 'Adm. Area Level 1'),
            'administrative_area_level_2_field' => Yii::t('app', 'Adm. Area Level 2'),
            'administrative_area_level_3_field' => Yii::t('app', 'Adm. Area Level 3'),
            'postal_code_field' => Yii::t('app', 'Postal Code'),
            'country_field' => Yii::t('app', 'Country'),
            'country_code_field' => Yii::t('app', 'Country Code'),
            'latitude_field' => Yii::t('app', 'Latitude'),
            'longitude_field' => Yii::t('app', 'Longitude'),
            'map_selector' => Yii::t('app', 'Map Selector'),
            'map_zoom' => Yii::t('app', 'Map Zoom'),
            'map_marker' => Yii::t('app', 'Show Map Marker'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGooglePlacesAutoComplete()
    {
        return $this->hasOne(GooglePlacesAutoComplete::class,['form_id'=>'form_id']);
    }

}