<?php

use yii\db\Migration;

/**
 * Class m200416_223106_upgrade_to_1_2
 */
class m200416_223106_upgrade_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%addon_google_places_autocomplete}}', 'geolocation', $this->boolean()->defaultValue(0)->after('api_key'));

        $this->addColumn('{{%addon_google_places_autocomplete_item}}', 'route_field', $this->text());
        $this->addColumn('{{%addon_google_places_autocomplete_item}}', 'street_number_field', $this->text());
        $this->addColumn('{{%addon_google_places_autocomplete_item}}', 'locality_field', $this->text());
        $this->addColumn('{{%addon_google_places_autocomplete_item}}', 'administrative_area_level_1_field', $this->text());
        $this->addColumn('{{%addon_google_places_autocomplete_item}}', 'postal_code_field', $this->text());
        $this->addColumn('{{%addon_google_places_autocomplete_item}}', 'country_field', $this->text());
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_google_places_autocomplete}}', 'geolocation');

        $this->dropColumn('{{%addon_google_places_autocomplete_item}}', 'route_field');
        $this->dropColumn('{{%addon_google_places_autocomplete_item}}', 'street_number_field');
        $this->dropColumn('{{%addon_google_places_autocomplete_item}}', 'locality_field');
        $this->dropColumn('{{%addon_google_places_autocomplete_item}}', 'administrative_area_level_1_field');
        $this->dropColumn('{{%addon_google_places_autocomplete_item}}', 'postal_code_field');
        $this->dropColumn('{{%addon_google_places_autocomplete_item}}', 'country_field');
    }
}
