<?php

use yii\db\Migration;

class m171026_035525_init_addon_google_places_autocomplete extends Migration
{
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_google_places_autocomplete}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),
            // Authorization
            'api_key' => $this->text()->notNull(),
            // Additional Settings
            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_google_places_autocomplete_item}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(), // Form Field ID
	        // Field settings
            'type' => $this->text(),
            'country' => $this->text(),
        ], $tableOptions);
    }

    public function down()
    {
        $this->dropTable('{{%addon_google_places_autocomplete_item}}');
        $this->dropTable('{{%addon_google_places_autocomplete}}');
    }

}
