<?php

use kartik\depdrop\DepDrop;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\field_encryption\models\FieldEncryption */
/* @var $itemModel app\modules\addons\modules\field_encryption\models\FieldEncryptionItem */
/* @var $forms array [id => name] of Form models */
/* @var $users array [id => name] of User models */
/* @var $permissions array [id => type] of Grant / Deny Permission to other users */

$this->title = Yii::t('app', 'Set Up a Form');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Field Encryption'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$url = Url::to(['/addons/field_encryption/admin/fields']);

if ($model->isNewRecord) {
    $model->status = 1;
    $itemModel->display = Yii::t('app', '-PERMISSION DENIED-');
}
?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(); ?>

                        <div class="row">
                            <div class="col-sm-6">
                                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                                    'data' => $forms,
                                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label(Yii::t('app', 'Form')); ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
                            </div>
                        </div>

                        <?php if(Yii::$app->user->can('selectUsers')): ?>
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'permission')->widget(Select2::class, [
                                        'data' => $permissions,
                                        'hideSearch' => true,
                                        'options' => ['placeholder' => Yii::t('app', 'Grant or Deny')],
                                        'pluginOptions' => [
                                            'allowClear' => true
                                        ],
                                    ])->hint(Yii::t('app', 'If you deny the permission to some users, the rest will be granted permission.')); ?>
                                </div>
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'users')->widget(Select2::class, [
                                        'data' => $users,
                                        'options' => [
                                            'multiple' => true,
                                            'placeholder' => Yii::t('app', 'Select a user...'),
                                        ],
                                        'pluginOptions' => [
                                            'allowClear' => true
                                        ],
                                    ])->hint(Yii::t('app', 'Leave this field empty, so that only you can view the decrypted data.')); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="row">
                            <div class="col-sm-12">
                                <legend><?= Yii::t('app', 'Fields') ?></legend>
                            </div>
                        </div>

                        <fieldset class="item">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($itemModel, '[0]field_id')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['fieldencryption-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-5">
                                    <?= $form->field($itemModel, '[0]display')->textInput([
                                        'maxlength' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="padding-top: 25px;">
                                        <button type="button" class="btn btn-icon btn-default btn-add">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset id="itemTemplate" class="d-none">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['fieldencryption-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $url,
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-5">
                                    <?= $form->field($itemModel, 'display')->textInput([
                                        'maxlength' => true,
                                        'disabled' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="padding-top: 25px;">
                                        <button type="button" class="btn btn-icon btn-default btn-remove">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <div class="form-group">
                            <?= Html::submitButton($model->isNewRecord ?
                                Yii::t('app', 'Save') :
                                Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
                        </div>

                        <?php ActiveForm::end(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

$this->registerCss("legend { margin-top: 20px; }");

$script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="FieldEncryptionItem[field_id]"]')
                    .attr('name', 'FieldEncryptionItem[' + item + '][field_id]')
                    .attr('id', 'fieldencryptionitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['fieldencryption-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="FieldEncryptionItem[display]"]')
                    .attr('name', 'FieldEncryptionItem[' + item + '][display]')
                    .attr('id', 'fieldencryptionitem-' + item + '-display')
                    .removeAttr('disabled')
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
$this->registerJs($script, $this::POS_END);
?>
