<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\field_encryption\models;

use Yii;

/**
 * This is the model class for table "{{%addon_field_encryption_item}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property string $field_id
 * @property string $action
 * @property string $display
 */
class FieldEncryptionItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_field_encryption_item}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id'], 'integer'],
            [['display'], 'string', 'max' => 2555],
            [['field_id', 'action'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form'),
            'field_id' => Yii::t('app', 'Field'),
            'action' => Yii::t('app', 'Action'),
            'display' => Yii::t('app', 'Display'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFieldEncryption()
    {
        return $this->hasOne(FieldEncryption::class,['form_id'=>'form_id']);
    }
}