<?php

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\facebook_login\models\FacebookApp */
/* @var $itemModel app\modules\addons\modules\facebook_login\models\FacebookAppItem */
/* @var $forms array [id => name] of Form models */

$this->title = Yii::t('app', 'Update Facebook Login');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Facebook Login'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Login') .' #'.
    $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('app', 'Update');

$url = Url::to(['/addons/facebook_login/admin/fields']);

?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin([
                            'options' => ['enctype' => 'multipart/form-data']
                        ]); ?>

                        <div class="row">
                            <div class="col-sm-6">
                                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                                    'data' => $forms,
                                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label(Yii::t('app', 'Form')); ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'app_id')->textInput() ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-3">
                                <?= $form->field($model, 'app_version')->textInput() ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'app_scope')->textInput() ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'login_button')->textInput() ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'logout_button')->textInput() ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <legend><?= Yii::t('app', 'Items') ?></legend>
                            </div>
                        </div>

                        <?php foreach($model->items as $i => $item): ?>
                            <fieldset class="item">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <?= Html::hiddenInput('item-'.$i.'-field_id',
                                            $item->field_id, ['id'=>'item-'.$i.'-field_id']) ?>
                                        <?= $form->field($item, '['.$i.']field_id')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['facebookapp-form_id'],
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => Url::to(['/addons/facebook_login/admin/fields']),
                                                'params'=>['item-'.$i.'-field_id'],
                                            ]
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-5">
                                        <?= $form->field($item, '['.$i.']facebook_data')->textInput([
                                            'maxlength' => true,
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-1">
                                        <button type="button" class="btn btn-default btn-remove" style="margin-top: 25px;">
                                            <i class="glyphicon glyphicon-minus"></i>
                                        </button>
                                    </div>
                                </div>
                            </fieldset>
                        <?php endforeach; ?>

                        <fieldset id="itemTemplate" class="hide">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= Html::hiddenInput('item-field_id', '', ['id'=>'item-field_id']) ?>
                                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['facebookapp-form_id'],
                                            'initialize' => true,
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => Url::to(['/addons/facebook_login/admin/fields']),
                                            'params'=>['item-field_id'],
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-5">
                                    <?= $form->field($itemModel, 'facebook_data')->textInput([
                                        'maxlength' => true,
                                        'disabled' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-1">
                                    <button type="button" class="btn btn-default btn-remove" style="margin-top: 25px;">
                                        <i class="glyphicon glyphicon-minus"></i>
                                    </button>
                                </div>
                            </div>
                        </fieldset>

                        <div class="form-group">
                            <?= Html::submitButton(Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
                        </div>

                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

$this->registerCss("legend { margin-top: 20px; }");

$script = <<<JS

$(window).on('load', function() {
    $('#facebookapp-form_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.glyphicon-minus').removeClass('glyphicon-minus').addClass('glyphicon-plus');

    $('#itemTemplate')
        .find('[name="FacebookAppItem[field_values]"]')
        .attr('disabled', true);        

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('hide')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update the name attributes
            cloned
                .find('[name="FacebookAppItem[facebook_data]"]')
                    .attr('name', 'FacebookAppItem[' + item + '][facebook_data]')
                    .attr('id', 'facebookappitem-' + item + '-facebook_data')
                    .removeAttr('disabled')
                    .end()
                .find('[name="FacebookAppItem[field_id]"]')
                    .attr('name', 'FacebookAppItem[' + item + '][field_id]')
                    .attr('id', 'facebookappitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['facebookapp-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-field_id')
                    .attr('name', 'item-' + item + '-field_id')
                    .attr('id', 'item-' + item + '-field_id')
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
$this->registerJs($script, $this::POS_END);
?>