<?php

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\facebook_login\models\FacebookApp */
/* @var $itemModel app\modules\addons\modules\facebook_login\models\FacebookAppItem */
/* @var $forms array [id => name] of Form models */

$this->title = Yii::t('app', 'Set Up a Facebook Login');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Facebook Login'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$url = Url::to(['/addons/facebook_login/admin/fields']);
?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(); ?>

                        <div class="row">
                            <div class="col-sm-6">
                                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                                    'data' => $forms,
                                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label(Yii::t('app', 'Form')); ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'app_id')->textInput() ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-3">
                                <?= $form->field($model, 'app_version')->textInput()->hint(Yii::t('app', 'API Version. For example: "v2.8"')) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'app_scope')->textInput()->hint(Yii::t('app', 'For example: "email, public_profile"')) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'login_button')->textInput()->hint(Yii::t('app', 'Link with the ID: facebook-login.')) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'logout_button')->textInput()->hint(Yii::t('app', 'Link with the ID: facebook-logout.')) ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <legend><?= Yii::t('app', 'Fields') ?></legend>
                            </div>
                        </div>

                        <fieldset class="item">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($itemModel, '[0]field_id')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['facebookapp-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => Url::to(['/addons/facebook_login/admin/fields']),
                                            'params'=>['facebookapp-item_1']
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-5">
                                    <?= $form->field($itemModel, '[0]facebook_data')->textInput([
                                        'maxlength' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="padding-top: 25px;">
                                        <button type="button" class="btn btn-default btn-add">
                                            <i class="glyphicon glyphicon-plus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset id="itemTemplate" class="hide">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['facebookapp-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => Url::to(['/addons/facebook_login/admin/fields']),
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-5">
                                    <?= $form->field($itemModel, 'facebook_data')->textInput([
                                        'maxlength' => true,
                                        'disabled' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="padding-top: 25px;">
                                        <button type="button" class="btn btn-default btn-remove">
                                            <i class="glyphicon glyphicon-minus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <div class="form-group">
                            <?= Html::submitButton($model->isNewRecord ?
                                Yii::t('app', 'Save') :
                                Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
                        </div>

                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php

$this->registerCss("legend { margin-top: 20px; }");

$script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('#itemTemplate')
        .find('[name="FacebookAppItem[facebook_data]"]')
        .attr('disabled', true);        

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('hide')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="FacebookAppItem[field_id]"]')
                    .attr('name', 'FacebookAppItem[' + item + '][field_id]')
                    .attr('id', 'facebookappitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['facebookapp-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="FacebookAppItem[facebook_data]"]')
                    .attr('name', 'FacebookAppItem[' + item + '][facebook_data]')
                    .attr('id', 'facebookappitem-' + item + '-facebook_data')
                    .removeAttr('disabled')
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
$this->registerJs($script, $this::POS_END);
?>
