<?php

use yii\helpers\Html;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;

/* @var $this yii\web\View */
/* @var $form yii\widgets\ActiveForm */
/* @var $model app\modules\addons\modules\facebook_login\models\FacebookApp */
/* @var $forms array [id => name] of Form models */
?>

<div class="facebook-login-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'form_id')
        ->widget(Select2::class, [
            'data' => $forms,
            'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ])
        ->label(Yii::t('app', 'Form')); ?>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'app_id')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'app_version')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'app_status')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ?
            Yii::t('app', 'Create') :
            Yii::t('app', 'Update'), [
            'class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>