<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\facebook_login\models;

use Yii;

/**
 * This is the model class for table "{{%addon_facebook_login_item}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property string $field_id
 * @property string $facebook_data
 */
class FacebookAppItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_facebook_login_item}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id'], 'integer'],
            [['field_id', 'facebook_data'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form'),
            'field_id' => Yii::t('app', 'Field'),
            'facebook_data' => Yii::t('app', 'Facebook Data'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getApp()
    {
        return $this->hasOne(FacebookApp::class,['form_id'=>'form_id']);
    }
}