<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Schema;
use yii\db\Migration;

class m150420_183551_init_addon_facebook_login extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_facebook_login}}', [
            'id' => Schema::TYPE_PK,
            'form_id' => Schema::TYPE_INTEGER . '(11) NOT NULL',
            'status' => Schema::TYPE_BOOLEAN . ' DEFAULT TRUE',

            'app_id' => Schema::TYPE_TEXT . ' NOT NULL',
            'app_version' => Schema::TYPE_TEXT . ' NOT NULL',
            'app_scope' => Schema::TYPE_TEXT . ' NOT NULL',

            'login_button' => Schema::TYPE_TEXT . ' NOT NULL',
            'logout_button' => Schema::TYPE_TEXT . ' NOT NULL',

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_facebook_login_item}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(), // Form Field ID
            'facebook_data' => $this->text(), // Field Values
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_facebook_login}}');
        $this->dropTable('{{%addon_facebook_login_item}}');
    }
}
